/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.TimeSource;
import org.exoplatform.portal.gadget.core.ExoContainerConfig;
import org.exoplatform.portal.gadget.core.SecurityTokenGenerator;
import org.exoplatform.web.application.RequestContext;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ExoDefaultSecurityTokenGenerator
implements SecurityTokenGenerator {
    private final TimeSource timeSource;
    private final Logger log = LoggerFactory.getLogger(ExoDefaultSecurityTokenGenerator.class);

    public ExoDefaultSecurityTokenGenerator() throws Exception {
        this.timeSource = new TimeSource();
    }

    protected String createToken(String gadgetURL, String owner, String viewer, Long moduleId, String container) {
        try {
            BlobCrypter blobCrypter = this.getBlobCrypter();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), gadgetURL);
            values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), String.valueOf(moduleId));
            values.put(AbstractSecurityToken.Keys.OWNER.getKey(), owner);
            values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), viewer);
            values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "");
            BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(container, null, null, values);
            return t.getContainer() + ':' + blobCrypter.wrap(t.toMap());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String createToken(String gadgetURL, Long moduleId) {
        String rUser;
        RequestContext context = RequestContext.getCurrentInstance();
        String viewer = rUser = context.getRemoteUser();
        return this.createToken(gadgetURL, viewer, rUser, moduleId, "default");
    }

    protected BlobCrypter getBlobCrypter() throws IOException {
        String fileName = this.getKeyFilePath();
        BasicBlobCrypter c = new BasicBlobCrypter(fileName);
        c.timeSource = this.timeSource;
        return c;
    }

    protected String getKeyFilePath() {
        String keyPath = ExoContainerConfig.getTokenKeyPath();
        File keyFile = null;
        keyFile = keyPath != null ? new File(keyPath) : new File("key.txt");
        return keyFile.getAbsolutePath();
    }
}

