/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.NestedScope;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionConstructor
extends AbstractExpression
implements NestedScope {
    private static final long serialVersionUID = 4183249730129328478L;
    private Identifier identifier;
    private List<FormalParam> params;
    private Block body;

    @ParseTreeNode.ReflectiveCtor
    public FunctionConstructor(FilePosition pos, Void value, List<? extends ParseTreeNode> children) {
        super(pos, ParseTreeNode.class);
        this.createMutation().appendChildren(children).execute();
    }

    public FunctionConstructor(FilePosition pos, Identifier identifier, List<FormalParam> params, Block body) {
        super(pos, ParseTreeNode.class);
        this.createMutation().appendChild(identifier).appendChildren(params).appendChild(body).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        List<? extends ParseTreeNode> children = this.children();
        int n = children.size();
        this.identifier = (Identifier)children.get(0);
        this.params = Collections.unmodifiableList(this.childrenPart(1, n - 1, FormalParam.class));
        for (FormalParam p : this.params) {
            if (p instanceof FormalParam) continue;
            throw new ClassCastException(p.getClass().getName());
        }
        this.body = (Block)this.children().get(n - 1);
    }

    public List<FormalParam> getParams() {
        return this.params;
    }

    public Block getBody() {
        return this.body;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierName() {
        return this.identifier.getName();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Boolean conditionResult() {
        return true;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        out.consume("function");
        String name = this.identifier.getName();
        if (null != name) {
            out.consume(name);
        }
        this.renderActuals(rc);
        this.renderBody(rc);
    }

    void renderActuals(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.consume("(");
        boolean seen = false;
        for (FormalParam e : this.params) {
            if (seen) {
                out.consume(",");
            } else {
                seen = true;
            }
            e.render(rc);
        }
        out.consume(")");
    }

    void renderBody(RenderContext rc) {
        this.body.renderBlock(rc, false);
    }

    @Override
    public String typeOf() {
        return "function";
    }

    @Override
    public JsonML toJsonML() {
        JsonMLCompatible.JsonMLBuilder builder = JsonMLCompatible.JsonMLBuilder.builder(TagType.FunctionExpr, this.getFilePosition());
        builder.addChild(this.getIdentifier());
        FilePosition paramPos = null;
        for (FormalParam p : this.getParams()) {
            paramPos = paramPos == null ? p.getFilePosition() : FilePosition.span(paramPos, p.getFilePosition());
        }
        if (paramPos == null) {
            paramPos = FilePosition.endOf(this.getIdentifier().getFilePosition());
        }
        JsonMLCompatible.JsonMLBuilder jsonMLBuilder = JsonMLCompatible.JsonMLBuilder.builder(TagType.ParamDecl, paramPos);
        for (FormalParam p : this.getParams()) {
            jsonMLBuilder.addChild(p.getIdentifier());
        }
        builder.addChild(jsonMLBuilder.build());
        for (Statement statement : this.getBody().children()) {
            if (statement instanceof DirectivePrologue) {
                ((DirectivePrologue)statement).addJsonMLTo(builder);
                continue;
            }
            builder.addChild(statement);
        }
        return builder.build();
    }
}

