/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeVisitor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;

public final class NonAsciiCheckVisitor
implements ParseTreeNodeVisitor {
    private final MessageQueue mq;

    public NonAsciiCheckVisitor(MessageQueue mq) {
        this.mq = mq;
    }

    public boolean visit(ParseTreeNode node) {
        if (!(node instanceof Identifier)) {
            return true;
        }
        Identifier ident = (Identifier)node;
        String name = ident.getName();
        if (!SyntheticNodes.is(ident) && name != null && !name.matches("^[a-zA-Z_$][a-zA-Z0-9_$]*$")) {
            this.mq.addMessage((MessageTypeInt)RewriterMessageType.NONASCII_IDENTIFIER, node.getFilePosition(), node);
        }
        return true;
    }
}

