/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.TranslatedCode;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.parser.quasiliteral.IllegalReferenceCheckRewriter;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.NonAsciiCheckVisitor;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import java.net.URI;

public class ExpressionSanitizerCaja {
    private final ModuleManager mgr;
    private final URI baseUri;

    public ExpressionSanitizerCaja(ModuleManager mgr, URI baseUri) {
        this.mgr = mgr;
        this.baseUri = baseUri;
    }

    public ParseTreeNode sanitize(ParseTreeNode input) {
        Block body;
        MessageQueue mq = this.mgr.getMessageQueue();
        ParseTreeNode result = null;
        if (input instanceof UncajoledModule && (body = ((UncajoledModule)input).getModuleBody()).children().size() == 2 && body.children().get(0) instanceof DirectivePrologue && ((DirectivePrologue)body.children().get(0)).hasDirective("use strict") && body.children().get(1) instanceof TranslatedCode) {
            result = input;
        }
        result = this.newES53Rewriter(this.mgr).expand(input);
        if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            return null;
        }
        result = new IllegalReferenceCheckRewriter(mq, false).expand(result);
        if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            return null;
        }
        result.visitPreOrder(new NonAsciiCheckVisitor(mq));
        if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            return null;
        }
        return result;
    }

    protected Rewriter newES53Rewriter(ModuleManager mgr) {
        return new ES53Rewriter(this.baseUri, mgr, false);
    }
}

