/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import org.jboss.logging.Logger;
import org.jboss.util.threadpool.StartTimeoutException;
import org.jboss.util.threadpool.Task;
import org.jboss.util.threadpool.TaskStoppedException;
import org.jboss.util.threadpool.TaskWrapper;

public class BasicTaskWrapper
implements TaskWrapper {
    private static final Logger log = Logger.getLogger(BasicTaskWrapper.class);
    public static final int TASK_NOT_ACCEPTED = 0;
    public static final int TASK_ACCEPTED = 1;
    public static final int TASK_STARTED = 2;
    public static final int TASK_COMPLETED = 3;
    public static final int TASK_REJECTED = -1;
    public static final int TASK_STOPPED = -2;
    private int state = 0;
    private Object stateLock = new Object();
    private Task task;
    private String taskString;
    private long startTime;
    private long startTimeout;
    private long completionTimeout;
    private int priority;
    private int waitType;
    private Thread runThread;

    protected BasicTaskWrapper() {
    }

    public BasicTaskWrapper(Task task) {
        this.setTask(task);
    }

    @Override
    public int getTaskWaitType() {
        return this.waitType;
    }

    @Override
    public int getTaskPriority() {
        return this.priority;
    }

    @Override
    public long getTaskStartTimeout() {
        return this.startTimeout;
    }

    @Override
    public long getTaskCompletionTimeout() {
        return this.completionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptTask() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                return;
            }
        }
        this.state = this.taskAccepted() ? 1 : -1;
        object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rejectTask(RuntimeException e) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = -1;
            this.stateLock.notifyAll();
        }
        this.taskRejected(e);
    }

    @Override
    public boolean isComplete() {
        return this.state == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTask() {
        boolean started;
        Object object = this.stateLock;
        synchronized (object) {
            started = this.state == 2;
            this.state = -2;
        }
        if (started) {
            if (this.runThread != null) {
                this.runThread.interrupt();
            }
            this.taskStop();
        } else if (this.runThread != null && this.runThread.isInterrupted()) {
            this.runThread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTask() {
        switch (this.waitType) {
            case 1: {
                boolean interrupted = false;
                Object object = this.stateLock;
                synchronized (object) {
                    while (this.state == 0 || this.state == 1) {
                        try {
                            this.stateLock.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.runThread = Thread.currentThread();
        long runTime = this.getElapsedTime();
        if (this.startTimeout > 0L && runTime >= this.startTimeout) {
            this.taskRejected(new StartTimeoutException("Start Timeout exceeded for task " + this.taskString));
            return;
        }
        boolean stopped = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == -2) {
                stopped = true;
            } else {
                this.state = 2;
                this.taskStarted();
                if (this.waitType == 1) {
                    this.stateLock.notifyAll();
                }
            }
        }
        if (stopped) {
            this.taskRejected(new TaskStoppedException("Task stopped for task " + this.taskString));
            return;
        }
        Throwable throwable = null;
        try {
            this.task.execute();
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.taskCompleted(throwable);
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.state = 3;
            if (this.waitType == 2) {
                this.stateLock.notifyAll();
            }
        }
    }

    protected void setTask(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Null task");
        }
        this.task = task;
        this.taskString = task.toString();
        this.startTime = System.currentTimeMillis();
        this.waitType = task.getWaitType();
        this.priority = task.getPriority();
        this.startTimeout = task.getStartTimeout();
        this.completionTimeout = task.getCompletionTimeout();
    }

    protected boolean taskAccepted() {
        try {
            this.task.accepted(this.getElapsedTime());
            return true;
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error during 'accepted' for task: " + this.taskString), t);
            return false;
        }
    }

    protected boolean taskRejected(RuntimeException e) {
        try {
            this.task.rejected(this.getElapsedTime(), e);
            return true;
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error during 'rejected' for task: " + this.taskString), t);
            if (e != null) {
                log.warn((Object)("Original reason for rejection of task: " + this.taskString), (Throwable)e);
            }
            return false;
        }
    }

    protected boolean taskStarted() {
        try {
            this.task.started(this.getElapsedTime());
            return true;
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error during 'started' for task: " + this.taskString), t);
            return false;
        }
    }

    protected boolean taskCompleted(Throwable throwable) {
        try {
            this.task.completed(this.getElapsedTime(), throwable);
            return true;
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error during 'completed' for task: " + this.taskString), t);
            if (throwable != null) {
                log.warn((Object)("Original error during 'run' for task: " + this.taskString), throwable);
            }
            return false;
        }
    }

    protected boolean taskStop() {
        try {
            this.task.stop();
            return true;
        }
        catch (Throwable t) {
            log.warn((Object)("Unexpected error during 'stop' for task: " + this.taskString), t);
            return false;
        }
    }

    protected long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    protected String getStateString() {
        switch (this.state) {
            case 0: {
                return "NOT_ACCEPTED";
            }
            case -1: {
                return "REJECTED";
            }
            case 1: {
                return "ACCEPTED";
            }
            case 2: {
                return "STARTED";
            }
            case -2: {
                return "STOPPED";
            }
            case 3: {
                return "COMPLETED";
            }
        }
        return "???";
    }
}

