/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import java.util.Locale;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class NotificationPluginUtils {
    private static OrganizationService organizationService;
    private static SettingService settingService;
    public static final String NOTIFICATION_SENDER_NAME = "exo:notificationSenderName";
    public static final String NOTIFICATION_SENDER_EMAIL = "exo:notificationSenderEmail";
    public static final String BRANDING_PORTAL_NAME = "exo:brandingPortalName";

    public static String getPortalName() {
        return NotificationPluginUtils.getExoContainerContext().getPortalContainerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstName(String userName) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        User user = null;
        try {
            UserHandler userHandler = NotificationPluginUtils.getOrganizationService().getUserHandler();
            user = userHandler.findUserByName(userName);
            String string = user.getFirstName();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    private static ExoContainerContext getExoContainerContext() {
        return (ExoContainerContext)PortalContainer.getInstance().getComponentInstanceOfType(ExoContainerContext.class);
    }

    public static String getFullName(String userId) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            String string = NotificationPluginUtils.getFullName(user);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    private static String getFullName(User user) {
        StringBuilder userInfor = new StringBuilder();
        String displayName = user.getDisplayName();
        if (displayName == null || displayName.length() == 0) {
            userInfor.append(user.getFirstName()).append(" ").append(user.getLastName());
        } else {
            userInfor.append(displayName);
        }
        return userInfor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEmailFormat(String userId) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            StringBuilder userInfor = new StringBuilder(NotificationPluginUtils.getFullName(user));
            userInfor.append("<").append(user.getEmail()).append(">");
            String string = userInfor.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    public static String getFrom(String from) {
        if (from != null && from.length() > 0 && from.indexOf("@") > 0) {
            return from;
        }
        return new StringBuffer(NotificationPluginUtils.getSenderName()).append("<").append(NotificationPluginUtils.getEmailFrom()).append(">").toString();
    }

    public static String getEmailFrom() {
        SettingValue<?> mail = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL.id(null), NOTIFICATION_SENDER_EMAIL);
        return mail != null ? (String)mail.getValue() : System.getProperty("gatein.email.smtp.from", "noreply@exoplatform.com");
    }

    public static String getSenderName() {
        SettingValue<?> name = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL.id(null), NOTIFICATION_SENDER_NAME);
        return name != null ? (String)name.getValue() : System.getProperty("exo.notifications.portalname", "eXo");
    }

    public static String getBrandingPortalName() {
        SettingValue<?> name = NotificationPluginUtils.getSettingService().get(Context.GLOBAL, Scope.GLOBAL.id(null), BRANDING_PORTAL_NAME);
        return name != null ? (String)name.getValue() : "eXo";
    }

    public static String getTo(String to) {
        if (to.indexOf("@") < 0) {
            return NotificationPluginUtils.getEmailFormat(to);
        }
        return to;
    }

    public static String getLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        String lang = null;
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.toString();
        }
        return lang;
    }

    public static OrganizationService getOrganizationService() {
        if (organizationService == null) {
            organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        }
        return organizationService;
    }

    public static SettingService getSettingService() {
        if (settingService == null) {
            settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return settingService;
    }

    private static void startRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)service));
        }
    }

    private static void endRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

