/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.Serializable;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CacheUserProfile {
    private static final Log LOG = ExoLogger.getLogger(CacheUserProfile.class);

    private static ExoCache<Serializable, UserProfile> getCache() throws Exception {
        return ((CacheService)CommonsUtils.getService(CacheService.class)).getCacheInstance("forum.UserProfiles");
    }

    public static void storeInCache(String userName, UserProfile userProfile) {
        try {
            ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
            Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
            cache.put(cacheKey, (Object)userProfile);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to storage UserProfile to eXoCache", (Throwable)e);
        }
    }

    public static void removeInCache(String userName) {
        try {
            ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
            Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
            cache.remove(cacheKey);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to remove UserProfile to eXoCache: " + userName));
        }
    }

    public static void clearCache() {
        try {
            ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
            cache.clearCache();
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to clear all UserProfile cached.");
        }
    }

    public static UserProfile getFromCache(String userName) {
        if (Utils.isEmpty(userName) || "user_gest_uoom".equals(userName)) {
            return null;
        }
        try {
            ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
            Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
            return (UserProfile)cache.get(cacheKey);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get UserProfile to eXoCache: " + userName));
            return null;
        }
    }

    private static Serializable getCacheKey(String userName) {
        return userName;
    }
}

