/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import org.gatein.pc.api.cache.CacheControl;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.ResourceInvocation;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.portlet.impl.jsr168.api.MimeResponseImpl;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;

public class ResourceResponseImpl
extends MimeResponseImpl
implements ResourceResponse {
    private final CacheLevel cacheability;
    private String encoding;

    public ResourceResponseImpl(ResourceInvocation invocation, PortletRequestImpl preq) {
        super((PortletInvocation)invocation, preq);
        CacheLevel cacheLevel = invocation.getCacheLevel();
        if (cacheLevel == null) {
            cacheLevel = CacheLevel.PAGE;
        }
        this.cacheability = cacheLevel;
        this.encoding = this.encoding;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null");
        }
        if (locale.getCountry().length() == 0) {
            this.addProperty("Content-Language", locale.getLanguage());
        } else {
            this.addProperty("Content-Language", locale.getLanguage() + "-" + locale.getCountry());
        }
    }

    @Override
    public void setContentType(String contentType) {
        super.setContentType(contentType);
    }

    public void setCharacterEncoding(String charset) {
        this.encoding = charset;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setContentLength(int i) {
        this.addProperty("Content-Length", "" + i);
    }

    @Override
    public PortletURL createActionURL() {
        this.checkCacheLevel();
        return super.createActionURL();
    }

    @Override
    public PortletURL createRenderURL() {
        this.checkCacheLevel();
        return super.createRenderURL();
    }

    private void checkCacheLevel() {
        if (this.cacheability != CacheLevel.PAGE) {
            throw new IllegalStateException("A resource cannot create URLs if the cache level hasn't been set to cacheLevelPage as mandated by JSR-286 PLT.13.7. Cache level was: " + this.cacheability);
        }
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, byte[] bytes, CacheControl cacheControl) {
        return new ContentResponse(props, attrs, contentType, this.encoding, bytes, cacheControl);
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, String chars, CacheControl cacheControl) {
        return new ContentResponse(props, attrs, contentType, this.encoding, chars, cacheControl);
    }

    @Override
    protected ContentResponse createResponse(ResponseProperties props, Map<String, Object> attrs, String contentType, CacheControl cacheControl) {
        return new ContentResponse(props, attrs, contentType, cacheControl);
    }
}

