/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.activity;

import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.ext.activity.ActivityExecutor;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.TopicActivityTask;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.impl.model.PostFilter;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ForumActivityUtils {
    private static final Log LOG = ExoLogger.getLogger(ForumActivityUtils.class);
    private static final int TYPE_PRIVATE = 2;

    public static Identity getSpaceIdentity(String forumId) {
        Space space = ForumActivityUtils.getSpaceService().getSpaceByGroupId(ForumActivityUtils.getSpaceGroupId(forumId));
        Identity spaceIdentity = null;
        if (space != null) {
            spaceIdentity = ForumActivityUtils.getIdentityManager().getOrCreateIdentity("space", space.getPrettyName(), false);
        }
        return spaceIdentity;
    }

    public static String getSpaceGroupId(String forumId) {
        String groupId = forumId.replaceFirst(Utils.FORUM_SPACE_ID_PREFIX, "");
        String spaceGroupId = "/spaces/" + groupId;
        return spaceGroupId;
    }

    public static boolean hasSpace(String forumId) {
        return !Utils.isEmpty((String)forumId) && forumId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) >= 0;
    }

    public static boolean isCategoryPublic(Category category) {
        return category != null && Utils.isEmpty((String[])category.getViewer()) && Utils.isEmpty((String[])category.getUserPrivate());
    }

    public static boolean isForumPublic(Forum forum) {
        return forum != null && !forum.getIsClosed() && Utils.isEmpty((String[])forum.getViewer());
    }

    public static boolean isTopicPublic(Topic topic) {
        return topic != null && topic.getIsActive() && topic.getIsApproved() && !topic.getIsWaiting() && !topic.getIsClosed() && Utils.isEmpty((String[])topic.getCanView());
    }

    public static boolean isPostPublic(Post post) {
        return post != null && post.getUserPrivate().length != 2 && !post.getIsWaiting() && !post.getIsHidden() && post.getIsActiveByTopic() && post.getIsApproved();
    }

    public static Topic getTopic(ForumActivityContext ctx) throws Exception {
        Post p = ctx.getPost();
        return ForumActivityUtils.getForumService().getTopic(p.getCategoryId(), p.getForumId(), p.getTopicId(), "");
    }

    public static void takeActivityBack(Topic topic, ExoSocialActivity activity) {
        ForumActivityUtils.takeActivityBack(topic, activity.getId());
    }

    public static void takeActivityBack(Topic topic, String activityId) {
        ForumActivityUtils.getForumService().saveActivityIdForOwnerPath(topic.getPath(), activityId);
    }

    public static void takeCommentBack(Post post, ExoSocialActivity comment) {
        ForumActivityUtils.takeCommentBack(post, comment.getId());
    }

    public static void takeCommentBack(Post post, String commentId) {
        ForumActivityUtils.getForumService().saveActivityIdForOwnerPath(post.getPath(), commentId);
    }

    public static void updateTopicPostCount(ForumActivityContext ctx, boolean isAdded) throws Exception {
        Topic topic = ForumActivityUtils.getTopic(ctx);
        ctx.setTopic(topic);
        ExoSocialActivity topicActivity = ForumActivityUtils.getActivityOfTopic(ctx);
        Map templateParams = topicActivity.getTemplateParams();
        templateParams.put("NumberOfReplies", "" + topic.getPostCount());
        ForumActivityUtils.getActivityManager().updateActivity(topicActivity);
    }

    public static void updateActivityByTopic(Topic topic, ExoSocialActivity activity) throws Exception {
        String topicPath = topic.getPath();
        PostFilter filter = new PostFilter(Utils.getCategoryId((String)topicPath), Utils.getForumId((String)topicPath), Utils.getTopicId((String)topicPath), "", "", "", "");
        ListAccess listPost = ForumActivityUtils.getForumService().getPosts(filter);
        if (listPost.getSize() <= 1) {
            return;
        }
        Post[] posts = (Post[])listPost.load(0, listPost.getSize());
        ActivityManager am = ForumActivityUtils.getActivityManager();
        int count = 0;
        for (Post post : posts) {
            if (post.getId().equals(topic.getId().replace(Utils.TOPIC, Utils.POST))) continue;
            String commentId = ForumActivityUtils.getForumService().getActivityIdForOwnerPath(post.getPath());
            ExoSocialActivity comment = null;
            if (commentId != null) {
                comment = am.getActivity(commentId);
            }
            if (commentId == null || comment == null) {
                comment = ForumActivityBuilder.createActivityComment(post, ForumActivityContext.makeContextForAddPost(post));
                comment.setUserId(ForumActivityUtils.getIdentity(post.getOwner()).getId());
            }
            comment.setTitle(ForumActivityBuilder.processContent(post.getMessage(), 3));
            am.saveComment(activity, comment);
            ForumActivityUtils.takeCommentBack(post, comment);
            ++count;
        }
        Map templateParams = activity.getTemplateParams();
        templateParams.put("NumberOfReplies", "" + count);
        activity.setTemplateParams(templateParams);
        am.updateActivity(activity);
    }

    public static void saveTopicActivity(Identity poster, Identity streamOwner, ExoSocialActivity activity, Topic topic) throws Exception {
        if (poster != null && streamOwner != null) {
            activity.setUserId(poster.getId());
            ForumActivityUtils.getActivityManager().saveActivityNoReturn(streamOwner, activity);
            ForumActivityUtils.updateActivityByTopic(topic, activity);
        }
    }

    public static String getActivityId(ForumActivityContext ctx) {
        ForumService fs = ForumActivityUtils.getForumService();
        String activityId = fs.getActivityIdForOwnerPath(ctx.getTopic().getPath());
        if (Utils.isEmpty((String)activityId)) {
            TopicActivityTask task = TopicActivityTask.ADD_TOPIC;
            ExoSocialActivity got = ActivityExecutor.execute(task, ctx);
            ForumActivityUtils.takeActivityBack(ctx.getTopic(), got);
            activityId = got.getId();
        }
        return activityId;
    }

    public static ExoSocialActivity getActivityOfTopic(ForumActivityContext ctx) {
        ForumService fs = ForumActivityUtils.getForumService();
        String activityId = fs.getActivityIdForOwnerId(ctx.getTopic().getId());
        if (Utils.isEmpty((String)activityId)) {
            return ForumActivityUtils.makeActivity(ctx);
        }
        ExoSocialActivity got = ForumActivityUtils.getActivityManager().getActivity(activityId);
        if (got == null) {
            got = ForumActivityUtils.makeActivity(ctx);
        }
        got.setBody(null);
        got.setTitle(null);
        return got;
    }

    public static ExoSocialActivity getCommentOfPost(String postPath) {
        ForumService fs = ForumActivityUtils.getForumService();
        String activityId = fs.getActivityIdForOwnerPath(postPath);
        ActivityManager am = ForumActivityUtils.getActivityManager();
        if (Utils.isEmpty((String)activityId)) {
            return null;
        }
        ExoSocialActivity got = am.getActivity(activityId);
        return got;
    }

    private static ExoSocialActivity makeActivity(ForumActivityContext ctx) {
        TopicActivityTask task = TopicActivityTask.ADD_TOPIC;
        ExoSocialActivity got = ActivityExecutor.execute(task, ctx);
        ForumActivityUtils.takeActivityBack(ctx.getTopic(), got);
        return got;
    }

    public static void removeActivities(String ... activityIds) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        for (String activityId : activityIds) {
            try {
                am.deleteActivity(activityId);
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot delete activity " + activityId), (Throwable)e);
            }
        }
    }

    public static void removeComment(String activityId, String commentId) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        ExoSocialActivity activity = am.getActivity(activityId);
        if (activity == null) {
            return;
        }
        activity = ForumActivityBuilder.updateNumberOfReplies(activity, true);
        activity.setTitle(null);
        activity.setBody(null);
        am.updateActivity(activity);
        am.deleteComment(activityId, commentId);
    }

    public static void updateActivities(ExoSocialActivity activity) {
        ActivityManager am = ForumActivityUtils.getActivityManager();
        am.updateActivity(activity);
    }

    public static ForumService getForumService() {
        return (ForumService)CommonsUtils.getService(ForumService.class);
    }

    public static ActivityManager getActivityManager() {
        return (ActivityManager)CommonsUtils.getService(ActivityManager.class);
    }

    public static IdentityManager getIdentityManager() {
        return (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    }

    public static SpaceService getSpaceService() {
        return (SpaceService)CommonsUtils.getService(SpaceService.class);
    }

    public static Identity getIdentity(String remoteId) {
        return ForumActivityUtils.getIdentityManager().getOrCreateIdentity("organization", remoteId, false);
    }

    public static ExoSocialActivity getActivityOfPollTopic(ForumActivityContext ctx) {
        String path = ctx.getTopic().getPath().concat("/").concat(ctx.getTopic().getId().replace(Utils.TOPIC, Utils.POLL));
        String pollActivityId = ForumActivityUtils.getForumService().getActivityIdForOwnerPath(path);
        ExoSocialActivity got = ForumActivityUtils.getActivityManager().getActivity(pollActivityId);
        return got;
    }

    public static String getActivityParamValue(ExoSocialActivity activity, String key) {
        String value = null;
        Map params = activity.getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    public static Topic getTopic(ExoSocialActivity activity) {
        String categoryId = ForumActivityUtils.getActivityParamValue(activity, "CateId");
        String forumId = ForumActivityUtils.getActivityParamValue(activity, "ForumId");
        String topicId = ForumActivityUtils.getActivityParamValue(activity, "TopicId");
        if (CommonUtils.isEmpty((String)topicId)) {
            return null;
        }
        try {
            return ForumActivityUtils.getForumService().getTopic(categoryId, forumId, topicId, "");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Post getPost(ExoSocialActivity activity) {
        String categoryId = ForumActivityUtils.getActivityParamValue(activity, "CateId");
        String forumId = ForumActivityUtils.getActivityParamValue(activity, "ForumId");
        String topicId = ForumActivityUtils.getActivityParamValue(activity, "TopicId");
        String postId = ForumActivityUtils.getActivityParamValue(activity, "PostId");
        if (CommonUtils.isEmpty((String)postId)) {
            return null;
        }
        try {
            return ForumActivityUtils.getForumService().getPost(categoryId, forumId, topicId, postId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Poll getPoll(ExoSocialActivity activity) {
        String pollId = ForumActivityUtils.getActivityParamValue(activity, "Id");
        if (pollId.indexOf(Utils.TOPIC) == 0) {
            pollId = pollId.replace(Utils.TOPIC, Utils.POLL);
        }
        try {
            return ((PollService)CommonsUtils.getService(PollService.class)).getPoll(pollId);
        }
        catch (Exception e) {
            return null;
        }
    }
}

