/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.wiki.mow.core.api.WikiStoreImpl;
import org.exoplatform.wiki.mow.core.api.wiki.WikiStore;
import org.exoplatform.wiki.service.impl.WikiChromatticLifeCycle;

public class MOWService {
    private WikiChromatticLifeCycle chromatticLifeCycle;

    public MOWService(ChromatticManager chromatticManager) {
        this.chromatticLifeCycle = (WikiChromatticLifeCycle)chromatticManager.getLifeCycle("wiki");
    }

    public ChromatticSession getSession() {
        return this.chromatticLifeCycle.getSession();
    }

    public boolean startSynchronization() {
        if (this.chromatticLifeCycle.getManager().getSynchronization() == null) {
            this.chromatticLifeCycle.getManager().beginRequest();
            return true;
        }
        return false;
    }

    public void stopSynchronization(boolean requestClose) {
        if (requestClose) {
            this.chromatticLifeCycle.getManager().endRequest(true);
        }
    }

    public boolean persist() {
        return this.persist(false);
    }

    public boolean persist(boolean isRefresh) {
        try {
            ChromatticSession chromatticSession = this.chromatticLifeCycle.getSession();
            if (chromatticSession.getJCRSession().hasPendingChanges()) {
                chromatticSession.getJCRSession().save();
                if (isRefresh) {
                    chromatticSession.getJCRSession().refresh(true);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public WikiStore getWikiStore() {
        boolean created = this.startSynchronization();
        ChromatticSession session = this.chromatticLifeCycle.getSession();
        WikiStoreImpl store = (WikiStoreImpl)session.findByPath(WikiStoreImpl.class, "exo:applications/eXoWiki/wikimetadata");
        if (store == null) {
            try {
                Node rootNode = session.getJCRSession().getRootNode();
                Node publicApplicationNode = rootNode.getNode("exo:applications");
                Node eXoWiki = null;
                try {
                    eXoWiki = publicApplicationNode.getNode("eXoWiki");
                }
                catch (PathNotFoundException e) {
                    eXoWiki = publicApplicationNode.addNode("eXoWiki");
                    publicApplicationNode.save();
                }
                Node wikiMetadata = eXoWiki.addNode("wikimetadata", "wiki:store");
                Node wikis = eXoWiki.addNode("wikis");
                session.save();
                store = (WikiStoreImpl)session.findByNode(WikiStoreImpl.class, wikiMetadata);
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
            finally {
                this.stopSynchronization(created);
            }
        }
        this.stopSynchronization(created);
        return store;
    }
}

