/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.OceanSG2;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class VOceanSG2
extends AbstractCoordTransBuilder {
    private String s = "";
    private String eta = "";
    private String depth = "";
    private String c = "";
    private String depth_c = "";

    public String getTransformName() {
        return "ocean_s_coordinate_g2";
    }

    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        String formula_terms = this.getFormula(ds, ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "s C eta depth depth_c");
        if (values == null) {
            return null;
        }
        this.s = values[0];
        this.c = values[1];
        this.eta = values[2];
        this.depth = values[3];
        this.depth_c = values[4];
        VerticalCT rs = new VerticalCT("OceanSG2_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.OceanSG2, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = eta(x,y) + (eta(x,y) + depth([n],x,y)) * ((depth_c*s(z) + depth([n],x,y)*C(z))/(depth_c+depth([n],x,y)))"));
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "S_variableName", ds, this.s)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_c_variableName", ds, this.depth_c)) {
            return null;
        }
        if (!this.addParameter(rs, "c_variableName", ds, this.c)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanSG2: s:" + this.s + " c:" + this.c + " eta:" + this.eta + " depth:" + this.depth + " depth_c:" + this.depth_c;
    }

    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new OceanSG2(ds, timeDim, vCT.getParameters());
    }
}

