/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OutboundTransferTask
implements Runnable {
    private static final Log log = LogFactory.getLog(OutboundTransferTask.class);
    private final boolean trace = log.isTraceEnabled();
    private final StateProviderImpl stateProvider;
    private final int topologyId;
    private final Address destination;
    private final Set<Integer> segments = new CopyOnWriteArraySet<Integer>();
    private final int stateTransferChunkSize;
    private final ConsistentHash readCh;
    private final DataContainer<Object, Object> dataContainer;
    private final PersistenceManager persistenceManager;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final Map<Integer, List<InternalCacheEntry>> entriesBySegment = CollectionFactory.makeConcurrentMap();
    private int accumulatedEntries;
    private FutureTask<Void> runnableFuture;
    private final RpcOptions rpcOptions;
    private InternalEntryFactory entryFactory;

    public OutboundTransferTask(Address destination, Set<Integer> segments, int stateTransferChunkSize, int topologyId, ConsistentHash readCh, StateProviderImpl stateProvider, DataContainer dataContainer, PersistenceManager persistenceManager, RpcManager rpcManager, CommandsFactory commandsFactory, InternalEntryFactory ef, long timeout, String cacheName) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("Segments must not be null or empty");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination address cannot be null");
        }
        if (stateTransferChunkSize <= 0) {
            throw new IllegalArgumentException("stateTransferChunkSize must be greater than 0");
        }
        this.stateProvider = stateProvider;
        this.destination = destination;
        this.segments.addAll(segments);
        this.stateTransferChunkSize = stateTransferChunkSize;
        this.topologyId = topologyId;
        this.readCh = readCh;
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.entryFactory = ef;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.rpcOptions = rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    public void execute(ExecutorService executorService) {
        if (this.runnableFuture != null) {
            throw new IllegalStateException("This task was already submitted");
        }
        this.runnableFuture = new FutureTask<Void>((Runnable)this, null){

            @Override
            protected void done() {
                OutboundTransferTask.this.stateProvider.onTaskCompletion(OutboundTransferTask.this);
            }
        };
        executorService.submit(this.runnableFuture);
    }

    public Address getDestination() {
        return this.destination;
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void run() {
        try {
            for (InternalCacheEntry<Object, Object> internalCacheEntry : this.dataContainer) {
                Object key = internalCacheEntry.getKey();
                int segmentId = this.readCh.getSegment(key);
                if (!this.segments.contains(segmentId) || internalCacheEntry.isL1Entry()) continue;
                this.sendEntry(internalCacheEntry, segmentId);
            }
            AdvancedCacheLoader stProvider = this.persistenceManager.getStateTransferProvider();
            if (stProvider != null) {
                try {
                    CollectionKeyFilter<Object> collectionKeyFilter = new CollectionKeyFilter<Object>(new ReadOnlyDataContainerBackedKeySet(this.dataContainer));
                    AdvancedCacheLoader.CacheLoaderTask task = new AdvancedCacheLoader.CacheLoaderTask(){

                        public void processEntry(MarshalledEntry me, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                            int segmentId = OutboundTransferTask.this.readCh.getSegment(me.getKey());
                            if (OutboundTransferTask.this.segments.contains(segmentId)) {
                                try {
                                    InternalCacheEntry icv = OutboundTransferTask.this.entryFactory.create(me.getKey(), me.getValue(), me.getMetadata());
                                    OutboundTransferTask.this.sendEntry(icv, segmentId);
                                }
                                catch (CacheException e) {
                                    log.failedLoadingValueFromCacheStore(me.getKey(), (Exception)((Object)e));
                                }
                            }
                        }
                    };
                    stProvider.process(collectionKeyFilter, task, new WithinThreadExecutor(), true, true);
                }
                catch (CacheException cacheException) {
                    log.failedLoadingKeysFromCacheStore((Exception)((Object)cacheException));
                }
            }
            this.sendEntries(true);
        }
        catch (Throwable t) {
            if (this.isCancelled()) {
                log.debugf("Transfer of segments %s of cache %s to node %s cancelled", this.segments, this.cacheName, this.destination);
            }
            log.failedOutBoundTransferExecution(t);
        }
        if (this.trace) {
            log.tracef("Outbound transfer of segments %s of cache %s to node %s is complete", this.segments, this.cacheName, this.destination);
        }
    }

    private void sendEntry(InternalCacheEntry ice, int segmentId) {
        List<InternalCacheEntry> entries;
        if (this.accumulatedEntries >= this.stateTransferChunkSize) {
            this.sendEntries(false);
            this.accumulatedEntries = 0;
        }
        if ((entries = this.entriesBySegment.get(segmentId)) == null) {
            entries = new ArrayList<InternalCacheEntry>();
            this.entriesBySegment.put(segmentId, entries);
        }
        entries.add(ice);
        ++this.accumulatedEntries;
    }

    private void sendEntries(boolean isLast) {
        List<InternalCacheEntry> entries;
        ArrayList<StateChunk> chunks = new ArrayList<StateChunk>();
        for (Map.Entry<Integer, List<InternalCacheEntry>> e : this.entriesBySegment.entrySet()) {
            entries = e.getValue();
            if (entries.isEmpty() && !isLast) continue;
            chunks.add(new StateChunk(e.getKey(), new ArrayList<InternalCacheEntry>(entries), isLast));
            entries.clear();
        }
        if (isLast) {
            Iterator<Object> iterator = this.segments.iterator();
            while (iterator.hasNext()) {
                int segmentId = (Integer)iterator.next();
                entries = this.entriesBySegment.get(segmentId);
                if (entries != null) continue;
                chunks.add(new StateChunk(segmentId, Collections.emptyList(), true));
            }
        }
        if (!chunks.isEmpty()) {
            if (this.trace) {
                if (isLast) {
                    log.tracef("Sending last chunk containing %d cache entries from segments %s of cache %s to node %s", new Object[]{this.accumulatedEntries, this.segments, this.cacheName, this.destination});
                } else {
                    log.tracef("Sending %d cache entries from segments %s of cache %s to node %s", new Object[]{this.accumulatedEntries, this.entriesBySegment.keySet(), this.cacheName, this.destination});
                }
            }
            StateResponseCommand cmd = this.commandsFactory.buildStateResponseCommand(this.rpcManager.getAddress(), this.topologyId, chunks);
            try {
                this.rpcManager.invokeRemotely(Collections.singleton(this.destination), cmd, this.rpcOptions);
            }
            catch (SuspectException e) {
                log.debugf("Node %s left cache %s while we were sending state to it, cancelling transfer.", this.destination, this.cacheName);
                this.cancel();
            }
            catch (Exception e) {
                if (this.isCancelled()) {
                    log.debugf("Stopping cancelled transfer of segments %s of cache %s to node %s", this.segments, this.cacheName, this.destination);
                }
                log.errorf(e, "Failed to send entries to node %s : %s", this.destination, e.getMessage());
            }
        }
    }

    public void cancelSegments(Set<Integer> cancelledSegments) {
        if (this.segments.removeAll(cancelledSegments)) {
            if (this.trace) {
                log.tracef("Cancelling outbound transfer of segments %s of cache %s to node %s (remaining segments %s)", new Object[]{cancelledSegments, this.cacheName, this.destination, this.segments});
            }
            this.entriesBySegment.keySet().removeAll(cancelledSegments);
            if (this.segments.isEmpty()) {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (this.runnableFuture != null && !this.runnableFuture.isCancelled()) {
            log.debugf("Cancelling outbound transfer of segments %s of cache %s to node %s", this.segments, this.cacheName, this.destination);
            this.runnableFuture.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.runnableFuture != null && this.runnableFuture.isCancelled();
    }

    public String toString() {
        return "OutboundTransferTask{topologyId=" + this.topologyId + ", destination=" + this.destination + ", segments=" + this.segments + ", stateTransferChunkSize=" + this.stateTransferChunkSize + ", timeout=" + this.timeout + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

