/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreTokenIndex;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.ContextualTask;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.gadget.core.GadgetToken;
import org.exoplatform.portal.gadget.core.GadgetTokenContainer;
import org.exoplatform.portal.gadget.core.GadgetTokenEntry;
import org.exoplatform.web.security.security.PlainTokenService;
import org.exoplatform.web.security.security.TokenServiceInitializationException;
import org.gatein.wci.security.Credentials;

public class GadgetTokenInfoService
extends PlainTokenService<GadgetToken, BasicOAuthStoreTokenIndex> {
    private ChromatticLifeCycle chromatticLifeCycle;

    public GadgetTokenInfoService(InitParams initParams, ChromatticManager chromatticManager) throws TokenServiceInitializationException {
        super(initParams);
        this.chromatticLifeCycle = chromatticManager.getLifeCycle("gadgettokens");
    }

    public void start() {
        try {
            this.chromatticLifeCycle.getManager().beginRequest();
            ChromatticSession session = this.chromatticLifeCycle.openContext().getSession();
            GadgetTokenContainer tkContainer = (GadgetTokenContainer)session.findByPath(GadgetTokenContainer.class, "gadgettokens");
            if (tkContainer == null) {
                session.insert(GadgetTokenContainer.class, "gadgettokens");
            }
        }
        finally {
            this.chromatticLifeCycle.getManager().endRequest(true);
        }
        super.start();
    }

    public GadgetToken createToken(final BasicOAuthStoreTokenIndex key, final OAuthStore.TokenInfo tokenInfo) {
        return (GadgetToken)((Object)new TokenTask<GadgetToken>(){

            @Override
            protected GadgetToken execute() {
                GadgetTokenContainer container = this.getGadgetTokenContainer();
                long expirationTimeMillis = System.currentTimeMillis() + GadgetTokenInfoService.this.validityMillis;
                return container.saveToken(key, tokenInfo, expirationTimeMillis);
            }
        }.executeWith(this.chromatticLifeCycle));
    }

    public GadgetToken getToken(final BasicOAuthStoreTokenIndex key) {
        return (GadgetToken)((Object)new TokenTask<GadgetToken>(){

            @Override
            protected GadgetToken execute() {
                return this.getGadgetTokenContainer().getToken(key);
            }
        }.executeWith(this.chromatticLifeCycle));
    }

    public GadgetToken deleteToken(final BasicOAuthStoreTokenIndex key) {
        return (GadgetToken)((Object)new TokenTask<GadgetToken>(){

            @Override
            protected GadgetToken execute() {
                return this.getGadgetTokenContainer().removeToken(key);
            }
        }.executeWith(this.chromatticLifeCycle));
    }

    public BasicOAuthStoreTokenIndex[] getAllTokens() {
        return (BasicOAuthStoreTokenIndex[])new TokenTask<BasicOAuthStoreTokenIndex[]>(){

            @Override
            protected BasicOAuthStoreTokenIndex[] execute() {
                GadgetTokenContainer container = this.getGadgetTokenContainer();
                Collection<GadgetTokenEntry> tokenEntries = container.getGadgetTokens().values();
                ArrayList<BasicOAuthStoreTokenIndex> tokenHolder = new ArrayList<BasicOAuthStoreTokenIndex>();
                for (GadgetTokenEntry tokenEntry : tokenEntries) {
                    tokenHolder.add(tokenEntry.getKey());
                }
                return tokenHolder.toArray(new BasicOAuthStoreTokenIndex[tokenHolder.size()]);
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public long size() {
        return (Long)new TokenTask<Long>(){

            @Override
            protected Long execute() {
                GadgetTokenContainer container = this.getGadgetTokenContainer();
                Collection<GadgetTokenEntry> tokens = container.getGadgetTokens().values();
                return tokens.size();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public String createToken(Credentials credentials) throws IllegalArgumentException, NullPointerException {
        return null;
    }

    protected BasicOAuthStoreTokenIndex decodeKey(String stringKey) {
        throw new UnsupportedOperationException();
    }

    private abstract class TokenTask<V>
    extends ContextualTask<V> {
        private SessionContext context;

        private TokenTask() {
        }

        protected final GadgetTokenContainer getGadgetTokenContainer() {
            ChromatticSession session = this.context.getSession();
            return (GadgetTokenContainer)session.findByPath(GadgetTokenContainer.class, "gadgettokens");
        }

        protected V execute(SessionContext context) {
            this.context = context;
            try {
                V v = this.execute();
                return v;
            }
            finally {
                this.context = null;
            }
        }

        protected abstract V execute();
    }
}

