/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.gadget.core.CharResponseWrapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class IfrServletFilter
implements Filter {
    private ServletContext ctx;
    private static final Log logger = ExoLogger.getLogger(IfrServletFilter.class);

    public void init(FilterConfig cfg) throws ServletException {
        this.ctx = cfg.getServletContext();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hreq = (HttpServletRequest)req;
        HttpServletResponse hresp = (HttpServletResponse)resp;
        String url = hreq.getParameter("url");
        if (url == null) {
            hresp.sendError(500, "No URL");
        } else {
            CharResponseWrapper responseWrapper = new CharResponseWrapper((HttpServletResponse)resp);
            chain.doFilter(req, (ServletResponse)responseWrapper);
            if (resp != null && hresp.getStatus() >= 400) {
                logger.debug("The error response code sent by gadget iframe servlet is {}", new Object[]{hresp.getStatus()});
                hresp.setStatus(400);
                hresp.setContentLength(0);
                hresp.getOutputStream().write("".getBytes());
            } else {
                PrintWriter responseWrapperWriter = responseWrapper.getWriter();
                responseWrapperWriter.flush();
                byte[] bytes = responseWrapper.getByteArray();
                hresp.setContentLength(bytes.length);
                hresp.getWriter().write(new String(bytes));
            }
        }
    }

    public void destroy() {
    }
}

