/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.Calendar;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

@Asynchronous
public class UpdateLoginTimeListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(UpdateLoginTimeListener.class);
    public static final String USER_PROFILE = "UserProfile";
    private PortalContainer container;
    private OrganizationService organizationService;

    public UpdateLoginTimeListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        UserHandler userHandler;
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        }
        if (!(userHandler = this.organizationService.getUserHandler()).isUpdateLastLoginTime()) {
            return;
        }
        ConversationState state = (ConversationState)event.getData();
        String userId = state.getIdentity().getUserId();
        boolean transactionOpened = false;
        if (this.organizationService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            transactionOpened = true;
        }
        try {
            User user = (User)state.getAttribute(USER_PROFILE);
            if (user == null) {
                user = userHandler.findUserByName(userId);
                state.setAttribute(USER_PROFILE, (Object)user);
            }
            user.setLastLoginTime(Calendar.getInstance().getTime());
            userHandler.saveUser(user, false);
        }
        catch (Exception e) {
            LOG.error("Error while updating the last login time for user {}", new Object[]{userId, e});
        }
        finally {
            if (transactionOpened) {
                RequestLifeCycle.end();
            }
        }
    }
}

