/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.cache;

import java.io.Serializable;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.cache.ElementCacheKey;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.cache.future.Loader;

public class TemplateCaching {
    private ExoCache<ElementCacheKey, Element> templateCache;
    private FutureExoCache<ElementCacheKey, Element, Object> futureExoCache;
    private static final String CACHING_NAME = "common.notification.caching";

    public TemplateCaching(CacheService cacheService) {
        this.templateCache = cacheService.getCacheInstance(CACHING_NAME);
        Loader<ElementCacheKey, Element, Object> loader = new Loader<ElementCacheKey, Element, Object>(){

            public Element retrieve(Object service, ElementCacheKey key) throws Exception {
                return TemplateUtils.loadGroovyElement(key.getPlugId(), key.getLanguage());
            }
        };
        this.futureExoCache = new FutureExoCache((Loader)loader, this.templateCache);
    }

    public Element getTemplateElement(ElementCacheKey cacheKey) {
        return (Element)this.futureExoCache.get(null, (Object)cacheKey);
    }

    public boolean isCached(ElementCacheKey cacheKey) {
        return this.templateCache.get((Serializable)cacheKey) != null;
    }

    public void put(ElementCacheKey cacheKey, Element value) {
        this.templateCache.put((Serializable)cacheKey, (Object)value);
    }
}

