/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.addons;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.addons.AddOnPlugin;
import org.exoplatform.commons.addons.PortletModel;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.PortletApplication;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;

public class AddOnPluginImpl
extends AddOnPlugin {
    private String containerName;
    private List<Application<?>> apps = new LinkedList();
    private int priority = 5;

    public AddOnPluginImpl(InitParams params) {
        if (params != null) {
            List tmp;
            ValueParam priorityParam;
            ValueParam containerParam = params.getValueParam("containerName");
            if (containerParam != null) {
                this.containerName = containerParam.getValue();
            }
            if ((priorityParam = params.getValueParam("priority")) != null) {
                this.priority = Integer.parseInt(priorityParam.getValue());
            }
            if ((tmp = params.getObjectParamValues(Application.class)) != null) {
                for (Application app : tmp) {
                    this.apps.add(this.buildApp(app));
                }
            }
        }
    }

    protected Application<?> buildApp(Application<?> app) {
        if (app instanceof PortletModel) {
            PortletModel portletModel = (PortletModel)app;
            PortletApplication pApp = new PortletApplication((ApplicationData)portletModel.build());
            List<String> permissions = portletModel.getPermissions();
            if (permissions != null) {
                pApp.setAccessPermissions(permissions.toArray(new String[permissions.size()]));
            }
            TransientApplicationState state = new TransientApplicationState(portletModel.getContentId());
            Map<String, Object> prefs = portletModel.getPortletPrefs();
            if (prefs != null) {
                PortletBuilder builder = new PortletBuilder();
                for (String key : prefs.keySet()) {
                    Object val = prefs.get(key);
                    if (val instanceof String) {
                        builder.add(key, (String)val);
                        continue;
                    }
                    if (!(val instanceof List)) continue;
                    builder.add(key, (List)val);
                }
                state.setContentState((Object)builder.build());
            }
            pApp.setState((ApplicationState)state);
            return pApp;
        }
        return app;
    }

    @Override
    public List<Application<?>> getApplications() {
        return Collections.unmodifiableList(this.apps);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }
}

