/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class ForumUserListener
extends UserEventListener {
    private static Log log = ExoLogger.getLogger(ForumUserListener.class);

    private ForumService getForumService() {
        return (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            try {
                this.getForumService().updateUserProfile(user);
            }
            catch (Exception e) {
                log.warn((Object)"Error while updating forum profile: ", (Throwable)e);
            }
            ForumServiceUtils.clearCache();
        }
    }

    public void postDelete(User user) throws Exception {
        try {
            this.getForumService().removeMember(user);
        }
        catch (Exception e) {
            log.warn((Object)"failed to remove member : ", (Throwable)e);
        }
        ForumServiceUtils.clearCache();
    }

    public void postSetEnabled(User user) {
        ForumService fservice = (ForumService)CommonsUtils.getService(ForumService.class);
        fservice.processEnabledUser(user.getUserName(), user.getEmail(), user.isEnabled());
        if (!user.isEnabled()) {
            try {
                fservice.userLogout(user.getUserName());
            }
            catch (Exception e) {
                log.warn((Object)String.format("Removes online for user %s is unsuccessful.", user.getUserName()));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        ForumServiceUtils.clearCache();
    }
}

