/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.ExitModes;
import com.google.caja.ancillary.linter.LexicalScope;
import com.google.caja.ancillary.linter.LiveSet;
import com.google.caja.ancillary.linter.ScopeAnalyzer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.CaseStmt;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Conditional;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.DebuggerStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DefaultCaseStmt;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.DoWhileLoop;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FinallyStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.ForLoop;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.LabeledStatement;
import com.google.caja.parser.js.LabeledStmtWrapper;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SwitchStmt;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.parser.js.TryStmt;
import com.google.caja.parser.js.WhileLoop;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.util.SyntheticAttributeKey;
import java.util.List;

final class VariableLiveness {
    static final SyntheticAttributeKey<LiveSet> LIVENESS = new SyntheticAttributeKey<LiveSet>(LiveSet.class, "liveness");

    VariableLiveness() {
    }

    static LiveSet livenessFor(ParseTreeNode node) {
        return node.getAttributes().get(LIVENESS);
    }

    static LiveCalc calculateLiveness(ParseTreeNode node) {
        return VariableLiveness.liveness(node, new LiveSet(node));
    }

    private static LiveCalc liveness(ParseTreeNode node, LiveSet onEntry) {
        LiveCalc onExit;
        node.getAttributes().set(LIVENESS, onEntry);
        if (node instanceof Statement) {
            onExit = VariableLiveness.processStatement((Statement)node, onEntry);
            if (node instanceof LabeledStatement) {
                onExit = VariableLiveness.processLabel((LabeledStatement)node, onExit);
            }
        } else if (node instanceof Expression) {
            onExit = new LiveCalc(VariableLiveness.processExpression((Expression)node, onEntry), ExitModes.COMPLETES);
        } else {
            throw new RuntimeException(node.getClass().getName());
        }
        onExit = onExit.filter(ScopeAnalyzer.containingScopeForNode(node));
        return onExit;
    }

    private static LiveCalc processStatement(Statement s, LiveSet onEntry) {
        if (s instanceof Block) {
            return VariableLiveness.processBlock((Block)s, onEntry);
        }
        if (s instanceof Conditional) {
            return VariableLiveness.processConditional((Conditional)s, onEntry);
        }
        if (s instanceof DoWhileLoop) {
            return VariableLiveness.processDoWhileLoop((DoWhileLoop)s, onEntry);
        }
        if (s instanceof WhileLoop) {
            return VariableLiveness.processWhileLoop((WhileLoop)s, onEntry);
        }
        if (s instanceof ForLoop) {
            return VariableLiveness.processForLoop((ForLoop)s, onEntry);
        }
        if (s instanceof ForEachLoop) {
            return VariableLiveness.processForEachLoop((ForEachLoop)s, onEntry);
        }
        if (s instanceof ExpressionStmt) {
            return VariableLiveness.processExpressionStmt((ExpressionStmt)s, onEntry);
        }
        if (s instanceof FunctionDeclaration) {
            return VariableLiveness.processFunctionDeclaration((FunctionDeclaration)s, onEntry);
        }
        if (s instanceof Declaration) {
            return VariableLiveness.processDeclaration((Declaration)s, onEntry);
        }
        if (s instanceof MultiDeclaration) {
            return VariableLiveness.processMultiDeclaration((MultiDeclaration)s, onEntry);
        }
        if (s instanceof SwitchStmt) {
            return VariableLiveness.processSwitchStmt((SwitchStmt)s, onEntry);
        }
        if (s instanceof DefaultCaseStmt) {
            return VariableLiveness.processDefaultCaseStmt((DefaultCaseStmt)s, onEntry);
        }
        if (s instanceof CaseStmt) {
            return VariableLiveness.processCaseStmt((CaseStmt)s, onEntry);
        }
        if (s instanceof TryStmt) {
            return VariableLiveness.processTryStmt((TryStmt)s, onEntry);
        }
        if (s instanceof CatchStmt) {
            return VariableLiveness.processCatchStmt((CatchStmt)s, onEntry);
        }
        if (s instanceof FinallyStmt) {
            return VariableLiveness.processFinallyStmt((FinallyStmt)s, onEntry);
        }
        if (s instanceof BreakStmt) {
            return VariableLiveness.processBreakStmt((BreakStmt)s, onEntry);
        }
        if (s instanceof ContinueStmt) {
            return VariableLiveness.processContinueStmt((ContinueStmt)s, onEntry);
        }
        if (s instanceof ReturnStmt) {
            return VariableLiveness.processReturnStmt((ReturnStmt)s, onEntry);
        }
        if (s instanceof ThrowStmt) {
            return VariableLiveness.processThrowStmt((ThrowStmt)s, onEntry);
        }
        if (s instanceof WithStmt) {
            return VariableLiveness.processWithStmt((WithStmt)s, onEntry);
        }
        if (s instanceof Noop) {
            return VariableLiveness.processNoop(onEntry);
        }
        if (s instanceof LabeledStmtWrapper) {
            return VariableLiveness.processLabeledStmtWrapper((LabeledStmtWrapper)s, onEntry);
        }
        if (s instanceof DirectivePrologue) {
            return VariableLiveness.processDirectivePrologue(onEntry);
        }
        if (s instanceof DebuggerStmt) {
            return new LiveCalc(onEntry, ExitModes.COMPLETES);
        }
        throw new RuntimeException(s.getClass().getName());
    }

    private static LiveSet processExpression(Expression e, LiveSet onEntry) {
        if (e instanceof Operation) {
            return VariableLiveness.processOperation((Operation)e, onEntry);
        }
        if (e instanceof FunctionConstructor) {
            VariableLiveness.processFunctionConstructor((FunctionConstructor)e);
            return onEntry;
        }
        if (e instanceof Reference) {
            return VariableLiveness.processReference((Reference)e, onEntry);
        }
        return VariableLiveness.processLiteralOrConstructor(e, onEntry);
    }

    private static LiveCalc processBlock(Block b, LiveSet onEntry) {
        LiveCalc onExit = new LiveCalc(onEntry, ExitModes.COMPLETES);
        for (Statement statement : b.children()) {
            if (!(statement instanceof FunctionDeclaration)) continue;
            onExit = VariableLiveness.liveness(statement, onExit.vars);
        }
        for (Statement statement : b.children()) {
            if (statement instanceof FunctionDeclaration) continue;
            LiveCalc r = VariableLiveness.liveness(statement, onExit.vars);
            onExit = r.exits.completes() ? new LiveCalc(r.vars.union(onExit.vars), r.exits.union(onExit.exits)) : r.withExits(onExit.exits.union(r.exits));
            if (onExit.exits.completes()) continue;
            break;
        }
        return onExit;
    }

    private static LiveCalc processConditional(Conditional c, LiveSet onEntry) {
        List<? extends ParseTreeNode> children = c.children();
        LiveSet afterLastCond = onEntry;
        LiveCalc onExit = null;
        int n = children.size();
        for (int i = 0; i <= n; i += 2) {
            LiveCalc afterClause;
            if (i != n) {
                if (i + 1 < n) {
                    ConditionalLiveSet afterCond = VariableLiveness.processCondition((Expression)children.get(i), afterLastCond);
                    afterClause = VariableLiveness.liveness(children.get(i + 1), afterCond.truthy);
                    afterLastCond = afterCond.falsey;
                } else {
                    afterClause = VariableLiveness.liveness(children.get(i), afterLastCond);
                }
            } else {
                afterClause = new LiveCalc(afterLastCond, ExitModes.COMPLETES);
            }
            onExit = onExit == null ? afterClause : new LiveCalc(afterClause.exits.completes() ? onExit.vars.intersection(afterClause.vars) : onExit.vars, afterClause.exits.intersection(onExit.exits));
        }
        assert (onExit != null);
        return onExit;
    }

    private static LiveCalc processDoWhileLoop(DoWhileLoop dw, LiveSet onEntry) {
        LiveCalc postBody = VariableLiveness.liveness(dw.getBody(), onEntry);
        LiveSet condVars = postBody.exits.completes() || postBody.exits.atContinue("") != null || postBody.exits.atContinue(dw.getLabel()) != null ? VariableLiveness.processCondition((Expression)dw.getCondition(), (LiveSet)postBody.vars).falsey : postBody.vars;
        return postBody.withVars(condVars);
    }

    private static LiveCalc processWhileLoop(WhileLoop s, LiveSet onEntry) {
        ConditionalLiveSet postCond = VariableLiveness.processCondition(s.getCondition(), onEntry);
        LiveCalc postBody = VariableLiveness.liveness(s.getBody(), postCond.truthy);
        return postBody.withVars(postCond.falsey.intersection(postBody.vars)).withExits(postBody.exits.intersection(ExitModes.COMPLETES));
    }

    private static LiveCalc processForLoop(ForLoop loop, LiveSet onEntry) {
        LiveCalc postInit = VariableLiveness.liveness(loop.getInitializer(), onEntry);
        ConditionalLiveSet postCond = VariableLiveness.processCondition(loop.getCondition(), postInit.vars);
        LiveCalc postBody = VariableLiveness.liveness(loop.getBody(), postCond.truthy);
        if (postBody.exits.completes()) {
            VariableLiveness.liveness(loop.getIncrement(), postBody.vars);
        }
        return postBody.withVars(postBody.exits.completes() ? postBody.vars.intersection(postCond.falsey) : postCond.falsey).withExits(postBody.exits.intersection(ExitModes.COMPLETES));
    }

    private static LiveCalc processForEachLoop(ForEachLoop s, LiveSet onEntry) {
        LiveCalc postObj = VariableLiveness.liveness(s.getContainer(), onEntry);
        Statement receiver = s.getKeyReceiver();
        LiveCalc preBody = VariableLiveness.liveness(s.getKeyReceiver(), postObj.vars);
        preBody = preBody.withExits(preBody.exits.union(postObj.exits));
        preBody = receiver instanceof Declaration ? preBody.withVars(preBody.vars.with((Declaration)receiver)) : preBody.withVars(preBody.vars.with((Reference)((ExpressionStmt)receiver).getExpression()));
        LiveCalc postBody = VariableLiveness.liveness(s.getBody(), preBody.vars);
        return postBody.withVars(postBody.vars.intersection(postObj.vars));
    }

    private static LiveCalc processExpressionStmt(ExpressionStmt es, LiveSet onEntry) {
        return VariableLiveness.liveness(es.getExpression(), onEntry);
    }

    private static LiveCalc processFunctionDeclaration(FunctionDeclaration fd, LiveSet onEntry) {
        VariableLiveness.liveness(fd.getInitializer(), onEntry);
        return new LiveCalc(onEntry.with(fd), ExitModes.COMPLETES);
    }

    private static LiveCalc processDeclaration(Declaration d, LiveSet onEntry) {
        if (d.getInitializer() == null) {
            return new LiveCalc(onEntry, ExitModes.COMPLETES);
        }
        LiveCalc postInit = VariableLiveness.liveness(d.getInitializer(), onEntry);
        return new LiveCalc(postInit.vars.with(d), postInit.exits);
    }

    private static LiveCalc processMultiDeclaration(MultiDeclaration md, LiveSet onEntry) {
        LiveCalc onExit = new LiveCalc(onEntry, ExitModes.COMPLETES);
        for (Declaration declaration : md.children()) {
            LiveCalc r = VariableLiveness.liveness(declaration, onExit.vars);
            onExit = new LiveCalc(r.vars.union(onExit.vars), r.exits.union(onExit.exits));
        }
        return onExit;
    }

    private static LiveCalc processSwitchStmt(SwitchStmt s, LiveSet onEntry) {
        List<? extends ParseTreeNode> children = s.children();
        LiveCalc postSwitchValue = VariableLiveness.liveness(children.get(0), onEntry);
        boolean sawDefault = false;
        LiveCalc last = null;
        int n = children.size();
        for (int i = 1; i < n; ++i) {
            ParseTreeNode node = children.get(i);
            if (node instanceof DefaultCaseStmt) {
                sawDefault = true;
            }
            ExitModes exits = last == null ? null : last.exits;
            last = VariableLiveness.liveness(node, postSwitchValue.vars);
            if (exits == null) continue;
            last = last.withExits(last.exits.intersection(exits));
        }
        if (sawDefault) {
            return last;
        }
        if (last == null) {
            return postSwitchValue;
        }
        return new LiveCalc(postSwitchValue.vars.intersection(last.vars), postSwitchValue.exits.intersection(last.exits));
    }

    private static LiveCalc processDefaultCaseStmt(DefaultCaseStmt s, LiveSet onEntry) {
        return VariableLiveness.liveness(s.getBody(), onEntry);
    }

    private static LiveCalc processCaseStmt(CaseStmt s, LiveSet onEntry) {
        LiveCalc postMatch = VariableLiveness.liveness(s.getCaseValue(), onEntry);
        return VariableLiveness.liveness(s.getBody(), postMatch.vars);
    }

    private static LiveCalc processTryStmt(TryStmt s, LiveSet onEntry) {
        LiveCalc preFinally;
        boolean hasFinally;
        LiveCalc postBody = VariableLiveness.liveness(s.getBody(), onEntry);
        boolean bl = hasFinally = s.getFinallyClause() != null;
        if (s.getCatchClause() != null) {
            boolean postBodyReturnsAbruptly = postBody.exits.returnsAbruptly();
            postBody = postBody.withExits(postBody.exits.withoutAbruptReturn());
            LiveCalc postCatch = VariableLiveness.liveness(s.getCatchClause(), onEntry.intersection(postBody.vars));
            preFinally = !hasFinally && postBody.exits.returnsNormally() ? postCatch : (!hasFinally && postCatch.exits.returns() ? postBody : (!postCatch.exits.completes() ? (hasFinally ? new LiveCalc(onEntry, postBody.exits.intersection(postCatch.exits)) : postBody) : (postBodyReturnsAbruptly || !postBody.exits.completes() ? postCatch : new LiveCalc(postBody.vars.intersection(postCatch.vars), ExitModes.COMPLETES))));
        } else {
            assert (hasFinally);
            preFinally = new LiveCalc(onEntry, ExitModes.COMPLETES);
        }
        if (hasFinally) {
            return VariableLiveness.liveness(s.getFinallyClause(), preFinally.vars);
        }
        return preFinally;
    }

    private static LiveCalc processCatchStmt(CatchStmt s, LiveSet onEntry) {
        VariableLiveness.liveness(s.getException(), onEntry);
        return VariableLiveness.liveness(s.getBody(), onEntry.with(s.getException()));
    }

    private static LiveCalc processFinallyStmt(FinallyStmt s, LiveSet onEntry) {
        return VariableLiveness.liveness(s.getBody(), onEntry);
    }

    private static LiveCalc processBreakStmt(BreakStmt s, LiveSet onEntry) {
        return new LiveCalc(onEntry, ExitModes.COMPLETES.withBreak(s, onEntry));
    }

    private static LiveCalc processContinueStmt(ContinueStmt s, LiveSet onEntry) {
        return new LiveCalc(onEntry, ExitModes.COMPLETES.withContinue(s, onEntry));
    }

    private static LiveCalc processReturnStmt(ReturnStmt rs, LiveSet onEntry) {
        LiveSet onExit;
        if (rs.getReturnValue() != null) {
            LiveCalc r = VariableLiveness.liveness(rs.getReturnValue(), onEntry);
            if (r.exits.returnsAbruptly()) {
                return r;
            }
            onExit = r.vars;
        } else {
            onExit = onEntry;
        }
        return new LiveCalc(onExit, ExitModes.COMPLETES.withNormalReturn(rs, onExit));
    }

    private static LiveCalc processThrowStmt(ThrowStmt ts, LiveSet onEntry) {
        LiveCalc onExit = VariableLiveness.liveness(ts.getException(), onEntry);
        return onExit.withExits(onExit.exits.withAbruptReturn(ts, onExit.vars));
    }

    private static LiveCalc processWithStmt(WithStmt ts, LiveSet onEntry) {
        LiveCalc afterObject = VariableLiveness.liveness(ts.getScopeObject(), onEntry);
        LiveCalc afterBody = VariableLiveness.liveness(ts.getBody(), afterObject.vars);
        VariableLiveness.scrub(ts.getBody());
        return afterObject.withExits(afterBody.exits);
    }

    private static void scrub(ParseTreeNode node) {
        node.getAttributes().remove(LIVENESS);
        for (ParseTreeNode parseTreeNode : node.children()) {
            VariableLiveness.scrub(parseTreeNode);
        }
    }

    private static LiveCalc processNoop(LiveSet onEntry) {
        return new LiveCalc(onEntry, ExitModes.COMPLETES);
    }

    private static LiveCalc processLabeledStmtWrapper(LabeledStmtWrapper s, LiveSet onEntry) {
        return VariableLiveness.liveness(s.getBody(), onEntry);
    }

    private static LiveSet processOperation(Operation op, LiveSet onEntry) {
        List<? extends Expression> operands = op.children();
        switch (op.getOperator()) {
            case TERNARY: {
                ConditionalLiveSet postCond = VariableLiveness.processLogicOperand(op, 0, onEntry);
                LiveCalc postThen = VariableLiveness.liveness(operands.get(1), postCond.truthy);
                LiveCalc liveCalc = VariableLiveness.liveness(operands.get(2), postCond.falsey);
                return postThen.vars.intersection(liveCalc.vars);
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                ConditionalLiveSet p = VariableLiveness.processCondition(op, onEntry);
                return p.truthy.intersection(p.falsey);
            }
            case FUNCTION_CALL: {
                if (!(operands.get(0) instanceof FunctionConstructor)) break;
                return VariableLiveness.processImmediatelyCalledFunction(op, onEntry);
            }
        }
        LiveSet postOperand = onEntry;
        for (Expression expression : operands) {
            postOperand = VariableLiveness.liveness((ParseTreeNode)expression, (LiveSet)postOperand).vars;
        }
        if (op instanceof AssignOperation && operands.get(0) instanceof Reference) {
            postOperand = postOperand.with((Reference)operands.get(0));
        }
        return postOperand;
    }

    private static ConditionalLiveSet processCondition(Expression e, LiveSet onEntry) {
        e.getAttributes().set(LIVENESS, onEntry);
        if (e instanceof Operation) {
            Operation op = (Operation)e;
            switch (op.getOperator()) {
                case LOGICAL_AND: {
                    ConditionalLiveSet left = VariableLiveness.processLogicOperand(op, 0, onEntry);
                    ConditionalLiveSet right = VariableLiveness.processLogicOperand(op, 1, left.truthy);
                    return new ConditionalLiveSet(left.truthy.union(right.truthy), left.falsey.intersection(right.falsey));
                }
                case LOGICAL_OR: {
                    ConditionalLiveSet left = VariableLiveness.processLogicOperand(op, 0, onEntry);
                    ConditionalLiveSet right = VariableLiveness.processLogicOperand(op, 1, left.falsey);
                    return new ConditionalLiveSet(left.truthy.intersection(right.truthy), left.falsey.union(right.falsey));
                }
                case NOT: {
                    return VariableLiveness.processLogicOperand(op, 0, onEntry).inverse();
                }
            }
        }
        LiveSet ls = VariableLiveness.processExpression(e, onEntry);
        return new ConditionalLiveSet(ls, ls);
    }

    private static ConditionalLiveSet processLogicOperand(Operation op, int opIdx, LiveSet onEntry) {
        return VariableLiveness.processCondition(op.children().get(opIdx), onEntry);
    }

    private static LiveSet processImmediatelyCalledFunction(Operation op, LiveSet onEntry) {
        List<? extends Expression> operands = op.children();
        FunctionConstructor fn = (FunctionConstructor)operands.get(0);
        LiveSet onExit = onEntry;
        for (Expression expression : operands.subList(1, operands.size())) {
            onExit = VariableLiveness.liveness((ParseTreeNode)expression, (LiveSet)onExit).vars;
        }
        LiveSet asAResultOfCallingFn = VariableLiveness.processFunctionConstructor(fn);
        return onExit.union(asAResultOfCallingFn);
    }

    private static LiveSet processFunctionConstructor(FunctionConstructor fc) {
        LiveSet fnBodyDefs = new LiveSet(fc);
        for (FormalParam formal : fc.getParams()) {
            fnBodyDefs = fnBodyDefs.with(formal);
        }
        return VariableLiveness.liveness((ParseTreeNode)fc.getBody(), (LiveSet)fnBodyDefs).vars;
    }

    private static LiveSet processReference(Reference r, LiveSet onEntry) {
        return onEntry;
    }

    private static LiveSet processLiteralOrConstructor(Expression e, LiveSet onEntry) {
        LiveSet last = onEntry;
        if (e instanceof ObjectConstructor) {
            for (ObjProperty objProperty : ((ObjectConstructor)e).children()) {
                last = VariableLiveness.liveness((ParseTreeNode)((ParseTreeNode)objProperty.children().get((int)1)), (LiveSet)last).vars;
            }
        } else {
            for (ParseTreeNode parseTreeNode : e.children()) {
                Expression childE = (Expression)parseTreeNode;
                last = VariableLiveness.liveness((ParseTreeNode)childE, (LiveSet)last).vars;
            }
        }
        return last;
    }

    private static LiveCalc processDirectivePrologue(LiveSet onEntry) {
        return new LiveCalc(onEntry, ExitModes.COMPLETES);
    }

    private static LiveCalc processLabel(LabeledStatement s, LiveCalc onExit) {
        String label = s.getLabel();
        LiveSet ls = onExit.vars;
        ExitModes em = onExit.exits;
        ExitModes.ExitMode breakSet = em.atBreak(label);
        if (breakSet != null) {
            ls = breakSet.always ? breakSet.vars : ls.intersection(breakSet.vars);
        }
        em = s.isTargetForContinue() ? em.withoutBreakOrContinue(label).withoutBreakOrContinue("") : em.withoutBreak(label).withoutBreak("");
        return onExit.withVars(ls).withExits(em);
    }

    private static final class ConditionalLiveSet {
        final LiveSet truthy;
        final LiveSet falsey;

        ConditionalLiveSet(LiveSet truthy, LiveSet falsey) {
            this.truthy = truthy;
            this.falsey = falsey;
        }

        ConditionalLiveSet inverse() {
            return new ConditionalLiveSet(this.falsey, this.truthy);
        }

        public String toString() {
            return "(truthy=" + this.truthy + ", falsey=" + this.falsey + ")";
        }
    }

    static final class LiveCalc {
        final LiveSet vars;
        final ExitModes exits;

        private LiveCalc(LiveSet vars, ExitModes exits) {
            this.vars = vars;
            this.exits = exits;
        }

        private LiveCalc filter(LexicalScope containingScope) {
            return this.withVars(this.vars.filter(containingScope));
        }

        private LiveCalc withExits(ExitModes exits) {
            return exits == this.exits ? this : new LiveCalc(this.vars, exits);
        }

        private LiveCalc withVars(LiveSet vars) {
            return vars == this.vars ? this : new LiveCalc(vars, this.exits);
        }

        public String toString() {
            return "[" + this.vars + " " + this.exits + "]";
        }
    }
}

