/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Loop;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoWhileLoop
extends Loop {
    private static final long serialVersionUID = 2725383192455487592L;
    private Statement body;
    private Expression condition;

    @ParseTreeNode.ReflectiveCtor
    public DoWhileLoop(FilePosition pos, String label, List<? extends ParseTreeNode> children) {
        this(pos, label, (Statement)children.get(0), (Expression)children.get(1));
    }

    public DoWhileLoop(FilePosition pos, String label, Statement body, Expression condition) {
        super(pos, label, ParseTreeNode.class);
        this.createMutation().appendChild(body).appendChild(condition).execute();
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        this.body = (Statement)this.children().get(0);
        this.condition = (Expression)this.children().get(1);
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Statement getBody() {
        return this.body;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String label = this.getRenderedLabel(rc);
        if (null != label) {
            out.consume(label);
            out.consume(":");
        }
        out.consume("do");
        this.body.renderBlock(rc, true);
        out.consume("while");
        out.consume("(");
        this.condition.render(rc);
        out.consume(")");
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public JsonML toJsonML() {
        return this.wrapIfLabelled(JsonMLCompatible.JsonMLBuilder.builder(TagType.DoWhileStmt, this.getFilePosition()).addChild(this.body).addChild(this.condition).build());
    }
}

