/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jobs {
    private MessageContext mc;
    private final MessageQueue mq;
    private final PluginMeta meta;
    private final List<JobEnvelope> jobs = Lists.newArrayList();

    public Jobs(MessageContext mc, MessageQueue mq, PluginMeta meta) {
        if (mc == null) {
            throw new NullPointerException();
        }
        if (mq == null) {
            throw new NullPointerException();
        }
        if (meta == null) {
            throw new NullPointerException();
        }
        this.mc = mc;
        this.mq = mq;
        this.meta = meta;
    }

    public void setMessageContext(MessageContext newMc) {
        this.mc = newMc;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public MessageQueue getMessageQueue() {
        return this.mq;
    }

    public PluginMeta getPluginMeta() {
        return this.meta;
    }

    public List<JobEnvelope> getJobs() {
        return this.jobs;
    }

    public List<JobEnvelope> getJobsByType(ContentType type, ContentType ... others) {
        List<JobEnvelope> matches = Lists.newArrayList();
        EnumSet<ContentType[]> types = EnumSet.of(type, others);
        for (JobEnvelope env : this.jobs) {
            if (!types.contains((Object)env.job.getType())) continue;
            matches.add(env);
        }
        return matches;
    }

    public boolean hasNoFatalErrors() {
        return this.hasNoMessagesOfLevel(MessageLevel.FATAL_ERROR);
    }

    public boolean hasNoErrors() {
        return this.hasNoMessagesOfLevel(MessageLevel.ERROR);
    }

    public boolean hasNoMessagesOfLevel(MessageLevel level) {
        for (Message m : this.getMessageQueue().getMessages()) {
            if (level.compareTo(m.getMessageLevel()) > 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.jobs.toString();
    }
}

