/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.plugin.JobEnvelope;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.HtmlExtractor;
import com.google.caja.plugin.stages.JobCache;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteHtmlStage
implements Pipeline.Stage<Jobs> {
    private final HtmlSchema htmlSchema;
    private final JobCache jobCache;

    public RewriteHtmlStage(HtmlSchema htmlSchema, JobCache jobCache) {
        this.htmlSchema = htmlSchema;
        this.jobCache = jobCache;
    }

    @Override
    public boolean apply(Jobs jobs) {
        for (JobEnvelope env : jobs.getJobsByType(ContentType.HTML, new ContentType[0])) {
            if (env.fromCache || !new HtmlExtractor(this.htmlSchema, this.jobCache, jobs, env).extract()) continue;
            env.job.getRoot().getAttributes().set(JobCache.NO_CACHE, true);
        }
        return jobs.hasNoFatalErrors();
    }
}

