/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.render.BufferingRenderer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.Indenter;
import com.google.caja.render.Spacer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsPrettyPrinter
extends BufferingRenderer {
    private int lineLengthLimit = 80;
    private boolean breakAfterComment = true;

    public JsPrettyPrinter(Concatenator out) {
        super(out);
    }

    public JsPrettyPrinter(StringBuilder out) {
        this(new Concatenator(out));
    }

    public void setLineLengthLimit(int lineLengthLimit) {
        this.lineLengthLimit = lineLengthLimit;
    }

    public int getLineLengthLimit() {
        return this.lineLengthLimit;
    }

    public void setBreakAfterComment(boolean breakAfterComment) {
        this.breakAfterComment = breakAfterComment;
    }

    public boolean isBreakAfterComment() {
        return this.breakAfterComment;
    }

    @Override
    List<String> splitTokens(List<Object> tokens) {
        Spacer spacer = new Spacer();
        for (Object lineEl : tokens) {
            if (lineEl instanceof FilePosition) {
                spacer.processMark((FilePosition)lineEl);
                continue;
            }
            spacer.processToken((String)lineEl);
        }
        List<String> outputTokens = spacer.getOutputTokens();
        Indenter indenter = new Indenter(outputTokens, this.breakAfterComment);
        indenter.breakLines();
        indenter.indent(this.lineLengthLimit);
        return outputTokens;
    }
}

