/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Service;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.OAuth2Utils;

public class OAuth2AuthorizationHandler {
    private OAuth2Service service;

    public OAuth2AuthorizationHandler(OAuth2Service service) {
        this.service = service;
    }

    public OAuth2NormalizedResponse handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            OAuth2NormalizedRequest normalizedReq = new OAuth2NormalizedRequest(request);
            OAuth2NormalizedResponse normalizedResp = new OAuth2NormalizedResponse();
            if (normalizedReq.getResponseType() != null) {
                switch (normalizedReq.getEnumeratedResponseType()) {
                    case CODE: {
                        this.service.validateRequestForAuthCode(normalizedReq);
                        OAuth2Code authCode = this.service.grantAuthorizationCode(normalizedReq);
                        normalizedResp.setCode(authCode.getValue());
                        if (normalizedReq.getState() != null) {
                            normalizedResp.setState(normalizedReq.getState());
                        }
                        normalizedResp.setHeader("Location", OAuth2Utils.buildUrl(authCode.getRedirectURI(), normalizedResp.getResponseParameters(), null));
                        normalizedResp.setStatus(302);
                        normalizedResp.setBodyReturned(false);
                        return normalizedResp;
                    }
                    case TOKEN: {
                        this.service.validateRequestForAccessToken(normalizedReq);
                        OAuth2Code accessToken = this.service.grantAccessToken(normalizedReq);
                        normalizedResp.setAccessToken(accessToken.getValue());
                        normalizedResp.setTokenType(OAuth2Types.TokenFormat.BEARER.toString());
                        normalizedResp.setExpiresIn(accessToken.getExpiration() - System.currentTimeMillis() + "");
                        if (normalizedReq.getState() != null) {
                            normalizedResp.setState(normalizedReq.getState());
                        }
                        normalizedResp.setHeader("Location", OAuth2Utils.buildUrl(accessToken.getRedirectURI(), null, normalizedResp.getResponseParameters()));
                        normalizedResp.setStatus(302);
                        normalizedResp.setBodyReturned(false);
                        return normalizedResp;
                    }
                }
                OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
                resp.setError(OAuth2Types.ErrorType.UNSUPPORTED_RESPONSE_TYPE.toString());
                resp.setErrorDescription("Unsupported response type");
                resp.setStatus(302);
                resp.setBodyReturned(false);
                throw new OAuth2Exception(resp);
            }
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.UNSUPPORTED_RESPONSE_TYPE.toString());
            resp.setErrorDescription("Unsupported response type");
            resp.setStatus(302);
            resp.setBodyReturned(false);
            throw new OAuth2Exception(resp);
        }
        catch (OAuth2Exception oae) {
            return oae.getNormalizedResponse();
        }
    }
}

