/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.HandlerPreconditions;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RequestItem;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.Service;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.service.SocialRequestItem;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.CollectionOptionsFactory;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;

@Service(name="people", path="/{userId}+/{groupId}/{personId}+")
public class PersonHandler {
    private final PersonService personService;
    private final ContainerConfig config;
    private final CollectionOptionsFactory collectionOptionsFactory;

    private static <T> Future<T> firstItem(Future<RestfulCollection<T>> collection) {
        Function firstItem = new Function<RestfulCollection<T>, T>(){

            public T apply(RestfulCollection<T> c) {
                if (c != null && c.getTotalResults() > 0) {
                    return c.getList().get(0);
                }
                return null;
            }
        };
        return Futures.lazyTransform(collection, (Function)firstItem);
    }

    @Inject
    public PersonHandler(PersonService personService, ContainerConfig config, CollectionOptionsFactory collectionOptionsFactory) {
        this.personService = personService;
        this.config = config;
        this.collectionOptionsFactory = collectionOptionsFactory;
    }

    @Operation(httpMethods={"GET"})
    public Future<?> get(SocialRequestItem request) throws ProtocolException {
        GroupId groupId = request.getGroup();
        ImmutableSet optionalPersonId = ImmutableSet.copyOf((Collection)request.getListParameter("personId"));
        Set fields = request.getFields(Person.Field.DEFAULT_FIELDS);
        Set<UserId> userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        if (userIds.size() > 1 && !optionalPersonId.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch personIds for multiple userIds");
        }
        CollectionOptions options = this.collectionOptionsFactory.create((RequestItem)request);
        if (userIds.size() == 1) {
            if (optionalPersonId.isEmpty()) {
                if (groupId.getType() == GroupId.Type.self) {
                    if (options.getFilter() != null) {
                        Future people = this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
                        return PersonHandler.firstItem(people);
                    }
                    return this.personService.getPerson(userIds.iterator().next(), fields, request.getToken());
                }
                return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
            }
            if (optionalPersonId.size() == 1) {
                ImmutableSet optionalUserIds = ImmutableSet.of((Object)new UserId(UserId.Type.userId, (String)optionalPersonId.iterator().next()));
                Future people = this.personService.getPeople((Set<UserId>)optionalUserIds, new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
                return PersonHandler.firstItem(people);
            }
            ImmutableSet.Builder personIds = ImmutableSet.builder();
            for (String pid : optionalPersonId) {
                personIds.add((Object)new UserId(UserId.Type.userId, pid));
            }
            return this.personService.getPeople((Set<UserId>)personIds.build(), new GroupId(GroupId.Type.self, null), options, fields, request.getToken());
        }
        return this.personService.getPeople(userIds, groupId, options, fields, request.getToken());
    }

    @Operation(httpMethods={"PUT"}, bodyParam="person")
    public Future<?> update(SocialRequestItem request) throws ProtocolException {
        Set<UserId> userIds = request.getUsers();
        HandlerPreconditions.requireNotEmpty(userIds, (String)"No userId specified");
        HandlerPreconditions.requireSingular(userIds, (String)"Multiple userIds not supported");
        UserId userId = userIds.iterator().next();
        return this.personService.updatePerson((UserId)Iterables.getOnlyElement(userIds), (Person)request.getTypedParameter("person", Person.class), request.getToken());
    }

    @Operation(httpMethods={"GET"}, path="/@supportedFields")
    public List<Object> supportedFields(RequestItem request) {
        String container = (String)Objects.firstNonNull((Object)request.getToken().getContainer(), (Object)"default");
        return this.config.getList(container, "${Cur['gadgets.features'].opensocial.supportedFields.person}");
    }
}

