/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.admin;

import com.google.caja.util.Sets;
import com.google.common.base.Objects;
import java.util.Set;

public class FeatureAdminData {
    private Set<String> features;
    private Type type;

    public FeatureAdminData() {
        this(null, null);
    }

    public FeatureAdminData(Set<String> features, Type type) {
        if (features == null) {
            features = Sets.newHashSet();
        }
        if (type == null) {
            type = Type.WHITELIST;
        }
        this.features = features;
        this.type = type;
    }

    private void addFeatures(Set<String> toAdd, Set<String> features) {
        for (String feature : toAdd) {
            if (feature == null) continue;
            features.add(feature);
        }
    }

    public void addFeatures(Set<String> toAdd) {
        this.addFeatures(toAdd, this.features);
    }

    private Set<String> createSingleFeatureSet(String feature) {
        Set features = Sets.newHashSet();
        if (feature != null) {
            features.add(feature);
        }
        return features;
    }

    public void addFeature(String toAdd) {
        Set<String> features = this.createSingleFeatureSet(toAdd);
        this.addFeatures(features);
    }

    public void clearFeatures() {
        this.features.clear();
    }

    private void removeFeatures(Set<String> toRemove, Set<String> features) {
        if (toRemove != null && features != null) {
            for (String feature : toRemove) {
                features.remove(feature);
            }
        }
    }

    public void removeFeatures(Set<String> toRemove) {
        this.removeFeatures(toRemove, this.features);
    }

    public void removeFeature(String toRemove) {
        Set<String> features = this.createSingleFeatureSet(toRemove);
        this.removeFeatures(features, this.features);
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            type = Type.WHITELIST;
        }
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeatureAdminData) {
            FeatureAdminData test = (FeatureAdminData)obj;
            return this.getFeatures().equals(test.getFeatures()) && this.getType().equals((Object)test.getType());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.features, this.type});
    }

    public static enum Type {
        WHITELIST,
        BLACKLIST;

    }
}

