/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.FeatureFile;
import org.apache.shindig.gadgets.features.FeatureFileSystem;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;

public class FeatureResourceLoader {
    private static final String classname = FeatureResourceLoader.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final HttpFetcher fetcher;
    private final TimeSource timeSource;
    private final FeatureFileSystem fileSystem;
    private int updateCheckFrequency = 0;

    @Inject
    public FeatureResourceLoader(HttpFetcher fetcher, TimeSource timeSource, FeatureFileSystem fileSystem) {
        this.fetcher = fetcher;
        this.timeSource = timeSource;
        this.fileSystem = fileSystem;
    }

    @Inject(optional=true)
    public void setSupportFileUpdates(@Named(value="shindig.features.loader.file-update-check-frequency-ms") int updateCheckFrequency) {
        this.updateCheckFrequency = updateCheckFrequency;
    }

    public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
        try {
            if ("file".equals(uri.getScheme())) {
                return this.loadFile(uri.getPath(), attribs);
            }
            if ("res".equals(uri.getScheme())) {
                return this.loadResource(uri.getPath(), attribs);
            }
            return this.loadUri(uri, attribs);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, (Throwable)e);
        }
    }

    protected FeatureResource loadFile(String path, Map<String, String> attribs) throws IOException {
        return new DualModeFileResource(this.getOptPath(path), path, attribs);
    }

    protected String getFileContent(FeatureFile file) {
        try {
            return file.getContent();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected FeatureResource loadResource(String path, Map<String, String> attribs) throws IOException {
        String optContent = null;
        String debugContent = null;
        try {
            optContent = this.getResourceContent(this.getOptPath(path));
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            debugContent = this.getResourceContent(path);
        }
        catch (IOException e) {
            // empty catch block
        }
        return new DualModeStaticResource(path, optContent, debugContent, attribs);
    }

    public String getResourceContent(String resource) throws IOException {
        return this.fileSystem.getResourceContent(resource);
    }

    protected FeatureResource loadUri(Uri uri, Map<String, String> attribs) throws IOException {
        String inline = attribs.get("inline");
        inline = inline != null ? inline : "";
        return new UriResource(this.fetcher, uri, "1".equals(inline) || "true".equalsIgnoreCase(inline), attribs);
    }

    protected String getOptPath(String orig) {
        if (orig.endsWith(".js") && !orig.endsWith(".opt.js")) {
            return orig.substring(0, orig.length() - 3) + ".opt.js";
        }
        return orig;
    }

    protected boolean fileHasChanged(FeatureFile file, long lastModified) {
        return file.lastModified() > lastModified;
    }

    private static final class UriResource
    extends FeatureResource.Attribute {
        private final HttpFetcher fetcher;
        private final Uri uri;
        private final boolean isInline;
        private String content;
        private long lastLoadTryMs;

        private UriResource(HttpFetcher fetcher, Uri uri, boolean isInline, Map<String, String> attribs) {
            super(attribs);
            this.fetcher = fetcher;
            this.uri = uri;
            this.isInline = isInline;
            this.lastLoadTryMs = 0L;
            this.content = this.getContent();
        }

        @Override
        public String getContent() {
            block8: {
                if (this.isExternal()) {
                    return this.uri.toString();
                }
                if (this.content != null) {
                    return this.content;
                }
                long now = System.currentTimeMillis();
                if (this.fetcher != null && now > this.lastLoadTryMs + 60000L) {
                    this.lastLoadTryMs = now;
                    try {
                        HttpRequest request = new HttpRequest(this.uri).setInternalRequest(true);
                        HttpResponse response = this.fetcher.fetch(request);
                        if (response.getHttpStatusCode() == 200) {
                            this.content = response.getResponseAsString();
                        } else if (LOG.isLoggable(Level.WARNING)) {
                            LOG.logp(Level.WARNING, classname, "getContent", "unableRetrieveLib", new Object[]{this.uri});
                        }
                    }
                    catch (GadgetException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block8;
                        LOG.logp(Level.WARNING, classname, "getContent", "unableRetrieveLib", new Object[]{this.uri});
                    }
                }
            }
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.getContent();
        }

        @Override
        public boolean isExternal() {
            return !this.isInline;
        }

        @Override
        public boolean isProxyCacheable() {
            return this.content != null;
        }

        @Override
        public String getName() {
            return this.uri.toString();
        }
    }

    private static final class DualModeStaticResource
    extends FeatureResource.Attribute {
        private final String content;
        private final String debugContent;
        private final String path;

        private DualModeStaticResource(String path, String content, String debugContent, Map<String, String> attribs) {
            super(attribs);
            this.content = content != null ? content : debugContent;
            this.debugContent = debugContent != null ? debugContent : content;
            this.path = path;
            Preconditions.checkArgument((this.content != null ? 1 : 0) != 0, (String)"Problems reading resource: %s", (Object[])new Object[]{path});
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getDebugContent() {
            return this.debugContent;
        }

        @Override
        public String getName() {
            return this.path;
        }
    }

    private class DualModeFileResource
    extends FeatureResource.Attribute {
        private final FileContent optContent;
        private final FileContent dbgContent;
        private final String fileName;

        protected DualModeFileResource(String optFilePath, String dbgFilePath, Map<String, String> attribs) {
            super(attribs);
            this.optContent = new FileContent(optFilePath);
            this.dbgContent = new FileContent(dbgFilePath);
            this.fileName = dbgFilePath;
            Preconditions.checkArgument((this.optContent.get() != null || this.dbgContent.get() != null ? 1 : 0) != 0, (String)"Problems reading resource: %s", (Object[])new Object[]{dbgFilePath});
        }

        @Override
        public String getContent() {
            String opt = this.optContent.get();
            return opt != null ? opt : this.dbgContent.get();
        }

        @Override
        public String getDebugContent() {
            String dbg = this.dbgContent.get();
            return dbg != null ? dbg : this.optContent.get();
        }

        @Override
        public String getName() {
            return this.fileName;
        }

        private final class FileContent {
            private final String filePath;
            private long lastModified;
            private long lastUpdateCheckTime;
            private String content;

            private FileContent(String filePath) {
                this.filePath = filePath;
                this.lastModified = 0L;
                this.lastUpdateCheckTime = 0L;
            }

            private String get() {
                long nowTime = FeatureResourceLoader.this.timeSource.currentTimeMillis();
                if (this.content == null || FeatureResourceLoader.this.updateCheckFrequency > 0 && this.lastUpdateCheckTime + (long)FeatureResourceLoader.this.updateCheckFrequency < nowTime) {
                    FeatureFile file;
                    this.lastUpdateCheckTime = nowTime;
                    try {
                        file = FeatureResourceLoader.this.fileSystem.getFile(this.filePath);
                    }
                    catch (IOException e) {
                        return null;
                    }
                    if (FeatureResourceLoader.this.fileHasChanged(file, this.lastModified)) {
                        String newContent = FeatureResourceLoader.this.getFileContent(file);
                        if (newContent != null) {
                            this.content = newContent;
                            this.lastModified = file.lastModified();
                        } else if (this.content != null && LOG.isLoggable(Level.WARNING)) {
                            LOG.logp(Level.WARNING, classname, "get", "missingFile", new Object[]{this.filePath});
                        }
                    }
                }
                return this.content;
            }
        }
    }
}

