/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.Inject;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.rewrite.js.JsCompiler;

public class CompilationProcessor
implements JsProcessor {
    private final JsCompiler compiler;

    @Inject
    public CompilationProcessor(JsCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) throws JsException {
        Iterable<JsContent> jsContents = builder.build().getAllJsContent();
        for (JsContent jsc : jsContents) {
            FeatureRegistry.FeatureBundle bundle = jsc.getFeatureBundle();
            if (bundle == null) continue;
            builder.appendExterns(bundle.getApis(ApiDirective.Type.JS, true));
        }
        JsResponse result = this.compiler.compile(request.getJsUri(), jsContents, builder.build().getExterns());
        builder.clearJs().appendAllJs(result.getAllJsContent());
        builder.setStatusCode(result.getStatusCode());
        builder.addErrors(result.getErrors());
        int refresh = result.getCacheTtlSecs();
        if (refresh > 0) {
            builder.setCacheTtlSecs(refresh);
        }
        return true;
    }
}

