/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestException;
import org.apache.shindig.gadgets.oauth2.OAuth2Utils;
import org.apache.shindig.gadgets.oauth2.handler.GrantRequestHandler;

public class CodeGrantTypeHandler
implements GrantRequestHandler {
    private static final OAuth2Error ERROR = OAuth2Error.CODE_GRANT_PROBLEM;

    @Override
    public HttpRequest getAuthorizationRequest(OAuth2Accessor accessor, String completeAuthorizationUrl) throws OAuth2RequestException {
        throw new OAuth2RequestException(ERROR, "inappropriate call to CodeGrantTypeHandler.getAuthorizationRequest()", null);
    }

    @Override
    public String getCompleteUrl(OAuth2Accessor accessor) throws OAuth2RequestException {
        String scope;
        OAuth2CallbackState state;
        if (accessor == null) {
            throw new OAuth2RequestException(ERROR, "accessor is null", null);
        }
        if (!accessor.isValid() || accessor.isErrorResponse() || accessor.isRedirecting()) {
            throw new OAuth2RequestException(ERROR, "accessor is invalid", null);
        }
        if (!accessor.getGrantType().equalsIgnoreCase("code")) {
            throw new OAuth2RequestException(ERROR, "grant type is not code", null);
        }
        HashMap queryParams = Maps.newHashMapWithExpectedSize((int)4);
        queryParams.put("response_type", this.getGrantType());
        queryParams.put("client_id", accessor.getClientId());
        String redirectUri = accessor.getRedirectUri();
        if (redirectUri != null && redirectUri.length() > 0) {
            queryParams.put("redirect_uri", redirectUri);
        }
        if ((state = accessor.getState()) != null) {
            try {
                queryParams.put("state", state.getEncryptedState());
            }
            catch (BlobCrypterException e) {
                throw new OAuth2RequestException(OAuth2Error.CODE_GRANT_PROBLEM, "encryption problem", e);
            }
        }
        if ((scope = accessor.getScope()) != null && scope.length() > 0) {
            queryParams.put("scope", scope);
        }
        for (Map.Entry<String, String> entry : accessor.getAdditionalRequestParams().entrySet()) {
            queryParams.put(entry.getKey(), entry.getValue());
        }
        return OAuth2Utils.buildUrl(accessor.getAuthorizationUrl(), queryParams, null);
    }

    @Override
    public String getGrantType() {
        return "code";
    }

    public static String getResponseType() {
        return "authorization_code";
    }

    @Override
    public boolean isAuthorizationEndpointResponse() {
        return true;
    }

    @Override
    public boolean isRedirectRequired() {
        return true;
    }

    @Override
    public boolean isTokenEndpointResponse() {
        return false;
    }
}

