/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.OAuth2Service;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAuth2Spec {
    private final Map<String, OAuth2Service> serviceMap = Maps.newHashMap();

    public OAuth2Spec(Element element, Uri base) throws SpecParserException {
        NodeList services = element.getElementsByTagName("Service");
        for (int i = 0; i < services.getLength(); ++i) {
            Node node = services.item(i);
            if (node.getNodeType() != 1) continue;
            this.parseService((Element)node, base);
        }
    }

    private void parseService(Element serviceElement, Uri base) throws SpecParserException {
        OAuth2Service service = new OAuth2Service(serviceElement, base);
        this.serviceMap.put(service.getName(), service);
    }

    public Map<String, OAuth2Service> getServices() {
        return Collections.unmodifiableMap(this.serviceMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<OAuth2>");
        for (Map.Entry<String, OAuth2Service> entry : this.serviceMap.entrySet()) {
            sb.append("<Service name='");
            sb.append(entry.getKey());
            sb.append("'>");
            OAuth2Service service = entry.getValue();
            if (service.getAuthorizationUrl() != null) {
                sb.append(service.getAuthorizationUrl().toString("Authorization"));
            }
            if (service.getTokenUrl() != null) {
                sb.append(service.getTokenUrl().toString("Token"));
            }
            sb.append("</Service>");
        }
        sb.append("</OAuth2>");
        return sb.toString();
    }
}

