/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.picketlink.identity.federation.bindings.wildfly.SAML2LoginModule;

public class SAML2WildflyIntegrationLoginModule
extends SAML2LoginModule {
    private static final String OPTION_REALM_NAME = "realmName";
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String OPTION_USE_SAML_ROLES = "useSAMLRoles";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"portalContainerName", "realmName", "useSAMLRoles"};
    private String portalContainerName;
    private boolean useSAMLRoles;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        try {
            this.addValidOptions(ALL_VALID_OPTIONS);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        super.initialize(subject, callbackHandler, sharedState, options);
        this.portalContainerName = this.getPortalContainerName(options);
        String useSAMLRoles = (String)options.get(OPTION_USE_SAML_ROLES);
        boolean bl = this.useSAMLRoles = useSAMLRoles != null && "true".equals(useSAMLRoles);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Using options: portalContainerName=" + this.portalContainerName + ", " + OPTION_USE_SAML_ROLES + "=" + this.useSAMLRoles));
        }
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            String username = this.getUsernameFromSharedState();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found user " + username + " in shared state."));
            }
            try {
                Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
                Identity identity = authenticator.createIdentity(username);
                this.sharedState.put("exo.security.identity", identity);
                this.subject.getPublicCredentials().add(new UsernameCredential(username));
                return true;
            }
            catch (Exception e) {
                this.log.debug((Object)("Exception during login process: " + e.getMessage()), (Throwable)e);
                throw new LoginException(e.getMessage());
            }
        }
        return false;
    }

    protected String getUsernameFromSharedState() {
        Object tmp = this.sharedState.get("javax.security.auth.login.name");
        if (tmp == null) {
            return null;
        }
        if (tmp instanceof Principal) {
            return ((Principal)tmp).getName();
        }
        return (String)tmp;
    }

    protected Group[] getRoleSets() throws LoginException {
        if (this.useSAMLRoles) {
            return super.getRoleSets();
        }
        return new Group[0];
    }

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            return optionValue;
        }
        return PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME;
    }

    private ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        }
        return container;
    }
}

