/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.impl.AbstractEventListAccess;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventNodeListAccess
extends AbstractEventListAccess<Node> {
    private static Log log = ExoLogger.getLogger(EventNodeListAccess.class);

    public EventNodeListAccess(EventDAOImpl evtDAO, EventQuery eventQuery) {
        super(evtDAO, eventQuery);
    }

    public Node[] load(int offset, int limit) {
        try {
            QueryResultImpl queryResult = super.loadData(offset, limit);
            if (queryResult != null) {
                NodeIterator nodes = queryResult.getNodes();
                LinkedList<Node> results = new LinkedList<Node>();
                while (nodes.hasNext()) {
                    results.add(nodes.nextNode());
                }
                return results.toArray(new Node[results.size()]);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }
}

