
package com.smartgwt.client.docs;

/**
 * <h3>Troubleshooting Super Dev Mode</h3>
 * This topic provides details on configuring and running Super Dev Mode, and troubleshooting
 * any problems.  For an overview see {@link com.smartgwt.client.docs.Debugging Debugging: Dev
 * Mode and Super Dev Mode}.
 *  <P>
 *  <h3>Super Dev Mode in GWT 2.7.0+</h3>
 *  <P>
 *  The recommended way of running Super Dev Mode in GWT 2.7.0+ is by installing the
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>GWT (Super) Dev Mode
 * Plugin</a>
 *  and launching the 
 * <a href='http://www.gwtproject.org/articles/superdevmode.html' target='_blank'>Super Dev Mode
 * Server</a>
 *  using a Web Application Run Configuration.  For more guidance beyond the overview in the
 *  previous link, see 
 * <a href='http://www.gwtproject.org/usingeclipse.html' target='_blank'>Using GWT with
 * Eclipse</a>.
 *  <P>
 *  <h3>Super Dev Mode in GWT 2.6.x and Earlier</h3>
 *  <P>
 *  For GWT releases before GWT 2.7.0, you must run the Code Server directly.  It can be
 * launched in <a href='https://www.eclipse.org/' target='_blank'>Eclipse</a> (with or without a
 * web server),
 *  or you can launch it from the command line.  Unless a web server is launched in Eclipse
 *  with the Code Server, you'll need to deploy the SGWT Web Application separately from the Code
 *  Server.  
 *  <P>
 *  At this point, it's assumed that you have installed the
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>GWT Eclipse Plugin</a>, and
 * that
 *  you already have an Eclipse Project containing your Java code with a valid classpath picking
 *  up the SGWT JARs and the GWT SDK Library (perhaps the same project you use for Dev Mode).
 *  <p>
 *  <h4>Creating a Run Configuration for the Code Server</h4>
 *  <p>
 *  You must first create a new Run Configuration for the GWT Code Server.  To do this:<ul>
 *  <li> Right Click / Run As... / Run Configurations
 *  <li> Select "Java Application", and hit the "New" button
 *  <li> Set the title (very top) to something you'll remember
 *  <li> Set the "Main class" to <code>com.google.gwt.dev.codeserver.CodeServer</code>
 *  <li> If using GWT 2.6.1 or earlier, then in the "Classpath" tab, add
 *       <code>gwt-codeserver.jar</code> using the "Add External Jar" button
 *  <li> In the "Arguments" Tab, add entries for (at a minimum) the source path and 
 *       the module (package, plus name of your .gwt.xml file) - for example:
 *       <code>-src src/ com.smartgwt.sample.BuiltInDS</code></ul>
 *  <p>
 *  For the required JAR above, you can either 
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>download</a> a version of the
 * GWT SDK
 *  and extract the needed JAR, or locate it in your Eclipse installation (from the GWT Plugin).
 *  Additional arguments beyond those mentioned in the last step above are supported in the
 *  "Arguments" Tab, such as specifying a port, bind address, etc.  Your Run Configuration 
 *  should now be complete.
 *  <p>
 *  <h4>Configuring your GWT Project</h4>
 *  <p>
 *  A few additions to your GWT Project must be made if you're using a GWT SDK version older
 *  than 2.7.  (They are included as comments in the "Built in DS" sample GWT Project, 
 *  BuiltInDS.gwt.xml.)  If you're running GWT SDK 2.6 or older, you must add:
 *  <p>
 *  <code>&lt;add-linker name="xsiframe" /&gt;</code>
 *  <p>
 *  and if you're running GWT SDK 2.5 or older, you must also add:
 *  <p>
 *  <code>&lt;set-configuration-property name="devModeRedirectEnabled" value="true" /&gt;</code>
 *  <p>
 *  <h4>Running the Code Server</h4>
 *  <p>
 *  At this stage you should be able to start the code server:<ul>
 *  <li> Right Click / Run As... / Run Configurations 
 *  <li> Select the new configuration you added</ul>
 *  <p>
 *  You should see a bunch of logging in the console tab of Eclipse, followed by a URL.  Visit
 *  that URL in your browser, and drag the "Dev Mode On" and "Dev Mode Off" buttons up to your
 *  browser bookmarks toolbar.  These bookmarks allow you to easily switch to Super Dev Mode
 *  (recompiling your Web Application) or switch back to Production Mode.
 *  <p>
 *  <h4>Deploying your Web Application</h4>
 *  <p>
 *  You should now launch the "Web Application" Run Configuration that it was suggested you use -
 *  the simplest way is to Right Click on the Project / Run As / Web Application.  Visit the URL
 *  generated by Eclipse, without the <code>gwt.codesvr</code> parameter.  You may see a
 *  warning about needing a recompile - you can either ignore this or run a full compile once to
 *  get rid of it.  (If you've deployed your Web Application manually outside of Eclipse, this
 *  section can be skipped.)
 *  <p>
 *  <h4>Entering Super Dev Mode</h4>
 *  <p>
 *  Visit the Production Mode URL of the running Web Application.  The bookmarks created earlier
 *  can now be used to enter Super Dev Mode:<ul>
 *  <li>hit the "Dev Mode On" bookmark link
 *  <li>on the pop-up, select the button to "Compile"</ul>
 *  <p>
 *  If you make code changes, you can update Super Dev Mode using the "Dev Mode On" bookmark.
 *  <P>
 *  <h3>Script Tags in Super Dev Mode</h3>
 *  <P>
 *  The official GWT Super Dev Mode linker (the default linker in GWT 2.7.0+) does not support
 *  including modules which load javascript files.  SmartGWT restores support for script tags
 *  by modifying some of the generated files with a post link step.  However, going forward
 *  it is recommended to migrate away from script tags in modules since we cannot control future
 *  changes to GWT that may introduce additional incompatibilities.
 *  <P>
 *  To avoid script tags if you're inheriting the standard module 
 *  <code>com.smartgwtee.SmartGwtEE</code>, you'll need to switch that to
 *  <code>com.smartgwtee.SmartGwtEENoScript</code>, and add the following
 *  lines to your bootstrap HTML file (under the "war" directory):
 *  <pre><code>
 *     &lt;script src="[app]/sc/modules/ISC_Core.js"&gt;          &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Foundation.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Containers.js"&gt;    &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Grids.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Forms.js"&gt;         &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_RichTextEditor.js"&gt;&lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_Calendar.js"&gt;      &lt;/script&gt;
 *     &lt;script src="[app]/sc/modules/ISC_DataBinding.js"&gt;   &lt;/script&gt;
 * 
 *     &lt;script src="[app]/sc/skins/[skinname]/load_skin.js"&gt;&lt;/script&gt;</code></pre>
 *  In the above lines:<ul>
 *  <li>Replace "<code>[app]</code>" with the directory containing the "sc" lib - determined by
 *  the "rename-to" attribute in your .gwt.xml file -- for example "builtinds" or "dsdmi".
 *  <li>Replace "<code>[skinname]</code>" with the name of the skin you want to use -- for
 *  example "Enterprise" or "Graphite".</ul>
 *  <p>
 *  <h3> Browser Source Map Support</h3>
 * As discussed in {@link com.smartgwt.client.docs.Debugging Debugging: Dev Mode and Super Dev
 * Mode}, not all browsers
 *  and debuggers at this time support the Source Maps feature that's required to set
 *  breakpoints for Super Dev Mode.  To enable them in Chrome, make sure the "Enable JavaScript
 *  Source Maps" checkbox is ticked in the Developer Tools preferences.  When the page is loaded
 *  and you've hit the "Dev Mode On" bookmark, you can browse the Java source in the debugger
 *  (under the "sources tab"), and set breakpoints in Java code.
 *  <p>
 *  <h3><u>Troubleshooting</u></h3>
 *  <table width="90%" class="normal" align="center" border="1" cellpadding="5">
 *  <tr bgcolor="#b0b0b0">
 *   <td width="30%"><b>Problem</b></td>
 *   <td width="30%"><b>Possible Causes</b></td>
 *   <td width="40%"><b>Solution</b></td>
 *  </tr><tr>
 *  <td>Missing GWT classes or JARs are reported when project is compiled.</td>
 *  <td>GWT Eclipse Plugin with GWT SDK is not installed or project was built with version
 *   different from what's configured in Eclipse and needs to be rebuilt.</td>
 *  <td>Install plugin (ticking checkbox for GWT SDK) from 
 * <a href='http://www.gwtproject.org/download.html' target='_blank'>here</a> and/or rebuild
 * project.</td>
 *  </tr><tr>
 *  <td>Error reported: "Could not find or load main class 
 *  com.google.gwt.dev.codeserver.<wbr>CodeServer".</td>
 *  <td>In GWT 2.6.1 and earlier, adding the GWT SDK library to your project's build path
 *  doesn't automatically add the gwt-codeserver.jar (included in the GWT SDK zip) to the build
 *  path.</td>
 *  <td>Add gwt-codeserver.jar as a separate JAR to the project build path.</td>
 *  </tr><tr>
 *  <td>Errors are reported by GWT about the "linker not supporting script tags" when your
 *  project is oompiled.</td>
 *  <td>The SmartGWT Linker has been enhanced to work around this issue, so you should no
 *  longer be affected by it when migrating from earlier GWT versions.</td>
 * <td>Report any remaining issues at <a href='http://forums.smartclient.com'
 * target='_blank'>http://forums.smartclient.com</a>.</td>
 *  </tr><tr>
 *  <td>Nothing happens when you visit the "Dev Mode On" bookmark.</td>
 *  <td>The GWT Code Server is not running or the bookmark is not valid.</td>
 *  <td>Start the Code Server or create new bookmarks from the URL displayed in the Eclipse
 *  console when the Code Server launches.</td>
 *  </tr><tr>
 *  <td>No GWT projects are found/available for recompiling when the modal dialog opens
 *  from clicking "Dev Mode On" bookmark, and you're running GWT 2.6 or earlier.</td>
 *  <td>Needed lines of the GWT Project file (gwt.xml) are missing or commented.</td>
 *  <td>Read section "Configuring your GWT Project" above and uncomment the appropriate
 *  gwt.xml lines based on your GWT version, or copy them from BuiltInDS.gwt.xml</td>
 *  </tr><tr>
 *  <td>When you launch your Web Application from Eclipse as directed above, you see an error
 *  in the browser indicating the GWT Plugin is missing (and perhaps that it's not available).
 *  </td><td>
 *  You've forgotten to remove the <code>gwt.codesvr</code> argument from the URL as
 *  we instructed above and the browser is not able to find the GWT Dev Mode Plugin.</td>
 *  <td>Remove the <code>gwt.codesvr</code> argument from the URL, or don't use the Eclipse GWT
 *  "Web Application" Run Configuration template (intended originally for Dev Mode) to launch
 *  your Web Application.  You may deploy your Web Application manually outside of Eclipse.</td>
 *  </tr><tr>
 *  <td>When the SDM Server is launched in Eclipse, the SGWT Application fails to
 *  load, resource or configuration files are reported missing, or browser errors are hit
 *  because the core Smart GWT JavaScript Framework files haven't been loaded properly.  
 *  Missing symbols may be reported, such as "isc is not defined".
 *  </td><td>JavaScript Framework or linker-created files are missing from the war directory, or
 *  your GWT project uses script tags, but you're not using or have not merged your app's main
 *  page from the BuiltInDS Sample Project HTML.  The linkers used by GWT for SDM don't support
 *  script tags, but SGWT generates code to load them for you automatically.  However, this
 *  requires that your app's HTML load the file loadScriptTagFiles.js as in the BuiltInDS Sample
 *  Project.</td>
 *  <td>Make sure to run the GWT Plugin in <i>Classic Dev Mode</i> at least once, to install the
 *  Framework resources and generate loadScriptTagFiles.js.  Then, if not already present, merge
 *  the line loading loadScriptTagFiles.js into your application's main HTML page from the
 *  BuiltInDS Sample Project.  (If you hit the latter issue, please add your opinion to the
 * <a href='https://github.com/gwtproject/gwt/issues/9149' target='_blank'>GWT Issue report</a> to
 * help
 *  get it resolved.)<br>
 *  Alternatively, you may run the Code Server Java app directly (even in GWT 2.7.0) rather than
 *  using the GWT SDM Server.  See the instructions above provided for GWT 2.6.x and ealier.</td>
 *  </tr><tr>
 *  <td>You're not able to connect to the SDM Code Server from a remote machine, even though
 *  you've launched it with -bindAddress 0.0.0.0 to enable all IP addresses to connect.</td>
 * <td>You're hitting a <a href='https://github.com/gwtproject/gwt/issues/8910'
 * target='_blank'>known issue</a>
 *  with SDM in GWT that affects any situation where the fully qualified server name is not
 *  available via DNS lookup on the client, even if you access the server by IP address.</td>
 *  <td>Ensure DNS lookup is available for the server on the client, or add a binding to your
 *  hosts files.</td>
 *  </tr></table>
 *  <p><b>
 *  A useful discussion of some other problems and solutions related to GWT Super Dev Mode can be
 * found <a href='http://stackoverflow.com/questions/18330001/super-dev-mode-in-gwt'
 * target='_blank'>here</a>.
 *  </b>
     * @see com.smartgwt.client.docs.Debugging
 */
public interface SuperDevModeTroubleshooting {
}
