/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.sanitization;

import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityConstants;

public class ECMSSecureJCRFoldersUpgradePlugin
extends UpgradeProductPlugin {
    private OrganizationService orgService;
    private DMSConfiguration dmsConfiguration;
    private ManageDriveService manageDriveService;
    private RepositoryService repoService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static final Log LOG = ExoLogger.getLogger((String)ECMSSecureJCRFoldersUpgradePlugin.class.getName());
    private SessionProvider sessionProvider;

    public ECMSSecureJCRFoldersUpgradePlugin(OrganizationService orgService, RepositoryService repoService, DMSConfiguration dmsConfiguration, ManageDriveService manageDriveService, NodeHierarchyCreator nodeHierarchyCreator, InitParams initParams) {
        super(initParams);
        this.manageDriveService = manageDriveService;
        this.orgService = orgService;
        this.repoService = repoService;
        this.dmsConfiguration = dmsConfiguration;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        this.migrateECMSystem(sessionProvider);
        this.migrateGroups(sessionProvider);
        this.migrateDigitalAssets(sessionProvider);
        this.migrateDrives(sessionProvider);
        sessionProvider.close();
    }

    private void migrateECMSystem(SessionProvider sessionProvider) {
        block3: {
            try {
                String[] relPaths;
                Session session = sessionProvider.getSession(this.dmsConfiguration.getConfig().getSystemWorkspace(), this.repoService.getCurrentRepository());
                Node ecmNode = (Node)session.getItem("/exo:ecm");
                for (String path : relPaths = new String[]{null, "exo:taxonomyTrees/definition", "exo:folksonomies/exo:tagStyles", "templates", "scripts", "metadata", "queries", "scripts/ecm-explorer", "scripts/ecm-explorer/action", "scripts/ecm-explorer/interceptor", "scripts/ecm-explorer/widget", "views", "views/templates", "views/userviews", "views/templates/ecm-explorer"}) {
                    this.removePermission(ecmNode, path, IdentityConstants.ANY);
                }
                this.removePermission(ecmNode, "exo:taxonomyTrees/storage", "*:/platform/users");
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"An unexpected error occurs when migrate /exo:ecm storage system", (Throwable)e);
            }
        }
    }

    private void migrateGroups(SessionProvider sessionProvider) {
        block2: {
            try {
                String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
                Node rootedNode = (Node)session.getItem(this.nodeHierarchyCreator.getJcrPath("groupsPath"));
                this.removePermission(rootedNode, null, "*:/platform/users");
                this.migrateGroup(rootedNode, null);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)"An unexpected error occurs when migrate /Groups", (Throwable)e);
            }
        }
    }

    private void migrateGroup(Node groupNode, Group group) throws Exception {
        GroupHandler groupHandler;
        Collection children;
        if (group != null) {
            this.removePermission(groupNode, "ApplicationData/Tags", IdentityConstants.ANY);
            this.removePermission(groupNode, "SharedData", IdentityConstants.ANY);
        }
        if ((children = (groupHandler = this.orgService.getGroupHandler()).findGroups(group)) != null) {
            for (Group childGroup : children) {
                try {
                    Node childGroupNode = groupNode.getNode(childGroup.getGroupName());
                    this.migrateGroup(childGroupNode, childGroup);
                }
                catch (PathNotFoundException e) {
                    LOG.warn((Object)("Could not find the group node: " + groupNode.getPath() + "/" + childGroup.getGroupName()));
                }
            }
        }
    }

    private void migrateDigitalAssets(SessionProvider sessionProvider) {
        block3: {
            try {
                String[] EXO_DIGITAL_PATH_ALIAS;
                String ws = this.repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(ws, this.repoService.getCurrentRepository());
                for (String digitalNodePath : EXO_DIGITAL_PATH_ALIAS = new String[]{"digitalVideoPath", "digitalAudioPath", "digitalAssetsPath", "digitalPicturePath"}) {
                    String exoDigitalNodePath = this.nodeHierarchyCreator.getJcrPath(digitalNodePath);
                    this.removePermission((Node)session.getItem(exoDigitalNodePath), null, "*:/platform/users");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"An unexpected error occurs when migrate /Digital Assets", (Throwable)e);
            }
        }
    }

    private void migrateDrives(SessionProvider sessionProvider) {
        DriveData drive = null;
        try {
            drive = this.manageDriveService.getDriveByName("Collaboration");
            drive.removePermission("*:/platform/web-contributors");
            this.manageDriveService.addDrive(drive.getName(), drive.getWorkspace(), drive.getPermissions(), drive.getHomePath(), drive.getViews(), drive.getIcon(), drive.getViewPreferences(), drive.getViewNonDocument(), drive.getViewSideBar(), drive.getShowHiddenNode(), drive.getAllowCreateFolders(), drive.getAllowNodeTypesOnTree());
        }
        catch (Exception e) {
            LOG.error((Object)"Could not get Collaboration drive", (Throwable)e);
        }
    }

    private void removePermission(Node rootedNode, String relativePath, String permission) throws RepositoryException {
        ExtendedNode node = null;
        if (relativePath != null) {
            try {
                node = (ExtendedNode)rootedNode.getNode(relativePath);
            }
            catch (PathNotFoundException ex) {
                LOG.warn((Object)("Could not find the node path: " + rootedNode.getPath() + "/" + relativePath));
            }
        } else {
            node = (ExtendedNode)rootedNode;
        }
        if (node != null) {
            node.removePermission(permission);
            node.save();
        }
    }
}

