/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.LessToCssCompiler;
import com.github.sommeri.less4j.core.parser.ANTLRParser;
import com.github.sommeri.less4j.core.parser.ASTBuilder;
import com.github.sommeri.less4j.core.problems.GeneralProblem;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.CssPrinter;
import com.github.sommeri.less4j.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.net.URL;

public class ThreadUnsafeLessCompiler
implements LessCompiler {
    private ProblemsHandler problemsHandler;
    private ASTBuilder astBuilder;
    private LessToCssCompiler compiler;
    private ANTLRParser parser = new ANTLRParser();

    @Override
    public LessCompiler.CompilationResult compile(String lessContent) throws Less4jException {
        return this.compile(new LessSource.StringSource(lessContent), null);
    }

    @Override
    public LessCompiler.CompilationResult compile(String lessContent, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.StringSource(lessContent), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(File lessFile) throws Less4jException {
        LessSource.FileSource lessSource = new LessSource.FileSource(lessFile);
        return this.compile(lessSource, null);
    }

    @Override
    public LessCompiler.CompilationResult compile(File lessFile, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.FileSource(lessFile), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(URL lessURL) throws Less4jException {
        return this.compile(new LessSource.URLSource(lessURL));
    }

    @Override
    public LessCompiler.CompilationResult compile(URL lessURL, LessCompiler.Configuration options) throws Less4jException {
        return this.compile(new LessSource.URLSource(lessURL), options);
    }

    @Override
    public LessCompiler.CompilationResult compile(LessSource source) throws Less4jException {
        return this.compile(source, null);
    }

    @Override
    public LessCompiler.CompilationResult compile(LessSource source, LessCompiler.Configuration options) throws Less4jException {
        this.problemsHandler = new ProblemsHandler();
        this.astBuilder = new ASTBuilder(this.problemsHandler);
        this.compiler = new LessToCssCompiler(this.problemsHandler);
        LessCompiler.CompilationResult compilationResult = this.doCompile(source, options);
        if (this.problemsHandler.hasErrors()) {
            throw new Less4jException(this.problemsHandler.getErrors(), compilationResult);
        }
        return compilationResult;
    }

    private LessCompiler.CompilationResult doCompile(LessSource source, LessCompiler.Configuration options) throws Less4jException {
        if (options == null) {
            options = new LessCompiler.Configuration();
        }
        ANTLRParser.ParseResult result = this.toAntlrTree(source);
        StyleSheet lessStyleSheet = this.astBuilder.parse(result.getTree());
        ASTCssNode cssStyleSheet = this.compiler.compileToCss(lessStyleSheet, source, options);
        LessCompiler.CompilationResult compilationResult = this.createCompilationResult(cssStyleSheet, source, options);
        return compilationResult;
    }

    private ANTLRParser.ParseResult toAntlrTree(LessSource source) throws Less4jException {
        ANTLRParser.ParseResult result;
        try {
            result = this.parser.parseStyleSheet(source.getContent(), source);
        }
        catch (LessSource.FileNotFound ex) {
            throw new Less4jException(new GeneralProblem("The file " + source + " does not exists."), new LessCompiler.CompilationResult(null));
        }
        catch (LessSource.CannotReadFile ex) {
            throw new Less4jException(new GeneralProblem("Cannot read the file " + source + "."), new LessCompiler.CompilationResult(null));
        }
        if (result.hasErrors()) {
            LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult("Errors during parsing phase, partial result is not available.");
            throw new Less4jException(result.getErrors(), compilationResult);
        }
        return result;
    }

    private LessCompiler.CompilationResult createCompilationResult(ASTCssNode cssStyleSheet, LessSource lessSource, LessCompiler.Configuration options) {
        LessSource cssDestination;
        LessSource lessSource2 = cssDestination = options == null ? null : options.getCssResultLocation();
        if (cssDestination == null) {
            String guessedCssName = URIUtils.changeSuffix(lessSource.getName(), ".css");
            URI guessedURI = URIUtils.changeSuffix(lessSource.getURI(), ".css");
            cssDestination = new LessSource.StringSource("", guessedCssName, guessedURI);
        }
        CssPrinter builder = new CssPrinter(lessSource, cssDestination);
        builder.append(cssStyleSheet);
        String css = builder.toCss();
        String sourceMap = builder.toSourceMap();
        LessCompiler.CompilationResult compilationResult = new LessCompiler.CompilationResult(css, sourceMap, this.problemsHandler.getWarnings());
        return compilationResult;
    }
}

