/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import com.google.inject.CreationException;
import com.google.inject.spi.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.common.PropertiesModule;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.gadget.core.GateInContainerConfigLoader;
import org.exoplatform.portal.gadget.core.GateInGuiceServletContextListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoPropertiesModule
extends PropertiesModule {
    private static final String GTN_SHINDIG_PROPERTIES = "shindig.properties";
    private Log log = ExoLogger.getLogger(ExoPropertiesModule.class);
    private final Properties properties;

    public ExoPropertiesModule() {
        RootContainer.getInstance();
        this.properties = this.readPropertyFile(GTN_SHINDIG_PROPERTIES);
    }

    protected Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        return super.getProperties();
    }

    protected Properties readPropertyFile(String propertyFile) {
        File file;
        Properties properties = null;
        InputStream is = null;
        String gadgetDir = PropertyManager.getProperty((String)"gatein.gadgets.dir");
        if (gadgetDir != null && (file = new File(new File(gadgetDir), propertyFile)).exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                this.log.debug((Object)("File " + file.getAbsolutePath() + " doesn't exist"));
            }
        }
        if (is == null) {
            GateInContainerConfigLoader currentLoader = GateInGuiceServletContextListener.getCurrentLoader();
            is = currentLoader.loadResourceAsStream(propertyFile);
        }
        try {
            if (is != null) {
                properties = new Properties();
                properties.load(is);
            }
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties: " + propertyFile)));
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return properties;
    }
}

