/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import org.jgroups.util.Average;
import org.jgroups.util.Bits;

public class AverageMinMax
extends Average {
    protected long min = Long.MAX_VALUE;
    protected long max = 0L;

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    @Override
    public <T extends Average> T add(long num) {
        super.add(num);
        this.min = Math.min(this.min, num);
        this.max = Math.max(this.max, num);
        return (T)this;
    }

    @Override
    public <T extends Average> T merge(T other) {
        super.merge(other);
        if (other instanceof AverageMinMax) {
            AverageMinMax o = (AverageMinMax)other;
            this.min = Math.min(this.min, o.min());
            this.max = Math.max(this.max, o.max());
        }
        return (T)this;
    }

    @Override
    public void clear() {
        super.clear();
        this.min = Long.MAX_VALUE;
        this.max = 0L;
    }

    @Override
    public String toString() {
        return String.format("min/avg/max=%d/%.2f/%d", this.min, this.getAverage(), this.max);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        super.writeTo(out);
        Bits.writeLong(this.min, out);
        Bits.writeLong(this.max, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        super.readFrom(in);
        this.min = Bits.readLong(in);
        this.max = Bits.readLong(in);
    }
}

