/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiPreferences;
import org.exoplatform.wiki.mow.api.WikiPreferencesSyntax;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.UIWikiSyntaxPreferences;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiEditPreferencesForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIWikiEditPreferencesForm
extends UIForm
implements UIPopupComponent {
    public static final String PREFERENCES_SYNTAX = "PreferencesSyntax";

    public UIWikiEditPreferencesForm() throws Exception {
        this.addUIFormInput(new UIWikiSyntaxPreferences(PREFERENCES_SYNTAX));
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UIWikiEditPreferencesForm> {
        public void execute(Event<UIWikiEditPreferencesForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiEditPreferencesForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.cancelPopupAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIWikiEditPreferencesForm> {
        public void execute(Event<UIWikiEditPreferencesForm> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiEditPreferencesForm)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiSyntaxPreferences uiSyntaxPreferences = (UIWikiSyntaxPreferences)wikiPortlet.findComponentById(UIWikiEditPreferencesForm.PREFERENCES_SYNTAX);
            UIFormSelectBox defaultSyntaxSelect = (UIFormSelectBox)uiSyntaxPreferences.getChildById("DefaultSyntax");
            UIFormCheckBoxInput allowCheckBox = (UIFormCheckBoxInput)uiSyntaxPreferences.getChildById("AllowChooseOthers");
            Wiki currentWiki = Utils.getCurrentWiki();
            WikiPreferences preferences = currentWiki.getPreferences();
            WikiPreferencesSyntax preferencesSyntax = preferences.getWikiPreferencesSyntax();
            preferencesSyntax.setAllowMultipleSyntaxes(allowCheckBox.isChecked());
            preferencesSyntax.setDefaultSyntax((String)defaultSyntaxSelect.getValue());
            UIPopupContainer popupContainer = wikiPortlet.getPopupContainer(UIWikiPortlet.PopupLevel.L1);
            popupContainer.deActivate();
        }
    }
}

