/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.auth;

import java.net.URL;
import java.util.HashMap;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.gadget.core.ExoDefaultSecurityTokenGenerator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.opensocial.auth.ExoBlobCrypterSecurityToken;
import org.exoplatform.web.application.RequestContext;

public class ExoSocialSecurityTokenGenerator
extends ExoDefaultSecurityTokenGenerator {
    private static Log LOG = ExoLogger.getLogger(ExoSocialSecurityTokenGenerator.class);

    protected String createToken(String gadgetURL, String owner, String viewer, Long moduleId, String container) {
        try {
            BlobCrypter crypter = this.getBlobCrypter();
            HashMap<String, String> values = new HashMap<String, String>();
            values.put(AbstractSecurityToken.Keys.APP_URL.getKey(), gadgetURL);
            values.put(AbstractSecurityToken.Keys.MODULE_ID.getKey(), String.valueOf(moduleId));
            values.put(AbstractSecurityToken.Keys.OWNER.getKey(), owner);
            values.put(AbstractSecurityToken.Keys.VIEWER.getKey(), viewer);
            values.put(AbstractSecurityToken.Keys.TRUSTED_JSON.getKey(), "");
            ExoBlobCrypterSecurityToken t = new ExoBlobCrypterSecurityToken(container, null, null, values);
            String portalContainer = PortalContainer.getCurrentPortalContainerName();
            PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
            String url = portalRequestContext.getRequest().getRequestURL().toString();
            URL requestURL = new URL(url);
            String hostName = requestURL.getProtocol() + "://" + requestURL.getAuthority();
            t.setPortalContainer(portalContainer);
            t.setHostName(hostName);
            t.setPortalOwner(portalRequestContext.getPortalOwner());
            return t.getContainer() + ":" + crypter.wrap(t.toMap());
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to generate token for gadget " + gadgetURL + " for owner " + owner), (Throwable)e);
            return null;
        }
    }

    public String createToken(String gadgetURL, Long moduleId) {
        String rUserId;
        RequestContext context = RequestContext.getCurrentInstance();
        String ownerId = rUserId = context.getRemoteUser();
        return this.createToken(gadgetURL, ownerId, rUserId, moduleId, "default");
    }
}

