/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.xwiki.chart.axis.AxisType;
import org.xwiki.chart.plot.PlotType;
import org.xwiki.rendering.internal.macro.chart.source.AbstractConfigurator;
import org.xwiki.rendering.internal.macro.chart.source.LocaleConfiguration;
import org.xwiki.rendering.internal.macro.chart.source.SimpleChartModel;
import org.xwiki.rendering.macro.MacroExecutionException;

public class AxisConfigurator
extends AbstractConfigurator {
    public static final String DOMAIN_AXIS_PARAM = "domain_axis_type";
    public static final String RANGE_AXIS_PARAM = "range_axis_type";
    public static final String DOMAIN_AXIS_DATE_FORMAT_PARAM = "domain_axis_date_format";
    public static final String RANGE_AXIS_DATE_FORMAT_PARAM = "range_axis_date_format";
    public static final String DOMAIN_AXIS_LOWER_PARAM = "domain_axis_lower";
    public static final String DOMAIN_AXIS_UPPER_PARAM = "domain_axis_upper";
    public static final String RANGE_AXIS_LOWER_PARAM = "range_axis_lower";
    public static final String RANGE_AXIS_UPPER_PARAM = "range_axis_upper";
    private AxisType[] axisTypes = new AxisType[]{null, null, null};
    private String[] axisDateFormat = new String[]{null, null, null};
    private final LocaleConfiguration localeConfiguration;
    private String[] axisLowerLimit = new String[]{null, null, null};
    private String[] axisUpperLimit = new String[]{null, null, null};

    public AxisConfigurator(LocaleConfiguration localeConfiguration) {
        this.localeConfiguration = localeConfiguration;
    }

    @Override
    public boolean setParameter(String key, String value) throws MacroExecutionException {
        boolean claimed = true;
        if (DOMAIN_AXIS_PARAM.equals(key)) {
            AxisType type = AxisType.forName((String)value);
            if (type == null) {
                this.invalidParameterValue(DOMAIN_AXIS_PARAM, value);
            }
            this.setAxisType(0, type);
        } else if (DOMAIN_AXIS_DATE_FORMAT_PARAM.equals(key)) {
            this.setAxisDateFormat(0, value);
        } else if (RANGE_AXIS_PARAM.equals(key)) {
            AxisType type = AxisType.forName((String)value);
            if (type == null) {
                this.invalidParameterValue(RANGE_AXIS_PARAM, value);
            }
            this.setAxisType(1, type);
        } else if (RANGE_AXIS_DATE_FORMAT_PARAM.equals(key)) {
            this.setAxisDateFormat(0, value);
        } else if (!this.claimLimitParameters(key, value)) {
            claimed = false;
        }
        return claimed;
    }

    private boolean claimLimitParameters(String key, String value) {
        boolean claimed = true;
        if (DOMAIN_AXIS_LOWER_PARAM.equals(key)) {
            this.axisLowerLimit[0] = value;
        } else if (DOMAIN_AXIS_UPPER_PARAM.equals(key)) {
            this.axisUpperLimit[0] = value;
        } else if (RANGE_AXIS_LOWER_PARAM.equals(key)) {
            this.axisLowerLimit[1] = value;
        } else if (RANGE_AXIS_UPPER_PARAM.equals(key)) {
            this.axisUpperLimit[1] = value;
        } else {
            claimed = false;
        }
        return claimed;
    }

    private void setAxisType(int index, AxisType axisType) {
        this.axisTypes[index] = axisType;
    }

    private void setAxisDateFormat(int index, String dateFormatString) throws MacroExecutionException {
        this.axisDateFormat[index] = dateFormatString;
    }

    public void setAxes(PlotType plotType, SimpleChartModel chartModel) throws MacroExecutionException {
        AxisType[] defaultAxisTypes = plotType.getDefaultAxisTypes();
        for (int i = 0; i < this.axisTypes.length; ++i) {
            CategoryAxis axis;
            AxisType type = this.axisTypes[i];
            if (i >= defaultAxisTypes.length) {
                if (type == null) continue;
                throw new MacroExecutionException("To many axes for plot type.");
            }
            if (type == null) {
                type = defaultAxisTypes[i];
            }
            switch (type) {
                case NUMBER: {
                    NumberAxis numberAxis = new NumberAxis();
                    axis = numberAxis;
                    this.setNumberLimits((ValueAxis)numberAxis, i);
                    break;
                }
                case CATEGORY: {
                    axis = new CategoryAxis();
                    break;
                }
                case DATE: {
                    DateAxis dateAxis = new DateAxis();
                    axis = dateAxis;
                    dateAxis.setTickMarkPosition(DateTickMarkPosition.END);
                    if (this.axisDateFormat[i] != null) {
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(this.axisDateFormat[i], this.localeConfiguration.getLocale());
                            dateAxis.setDateFormatOverride((DateFormat)dateFormat);
                        }
                        catch (IllegalArgumentException e) {
                            throw new MacroExecutionException(String.format("Invalid date format [%s].", this.axisDateFormat[i]));
                        }
                    }
                    this.setDateLimits(dateAxis, i);
                    break;
                }
                default: {
                    throw new MacroExecutionException(String.format("Unsupported axis type [%s]", type.getName()));
                }
            }
            chartModel.setAxis(i, (Axis)axis);
        }
    }

    private void setNumberLimits(ValueAxis axis, int index) throws MacroExecutionException {
        try {
            Number number;
            if (this.axisLowerLimit[index] != null) {
                number = NumberUtils.createNumber((String)StringUtils.trim((String)this.axisLowerLimit[index]));
                axis.setLowerBound(number.doubleValue());
            }
            if (this.axisUpperLimit[index] != null) {
                number = NumberUtils.createNumber((String)StringUtils.trim((String)this.axisUpperLimit[index]));
                axis.setUpperBound(number.doubleValue());
            }
        }
        catch (NumberFormatException e) {
            throw new MacroExecutionException("Invalid number in axis bound.", (Throwable)e);
        }
    }

    private void setDateLimits(DateAxis axis, int index) throws MacroExecutionException {
        try {
            Date date;
            if (this.axisLowerLimit[index] != null) {
                date = this.localeConfiguration.getDateFormat().parse(StringUtils.trim((String)this.axisLowerLimit[index]));
                axis.setMinimumDate(date);
            }
            if (this.axisUpperLimit[index] != null) {
                date = this.localeConfiguration.getDateFormat().parse(StringUtils.trim((String)this.axisUpperLimit[index]));
                axis.setMaximumDate(date);
            }
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Invalid date in axis bound.", (Throwable)e);
        }
    }
}

