/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

public class Invitation {
    private String eventId;
    private String participant;
    private String status;

    public Invitation(String eventId, String participant, String status) {
        this.eventId = eventId;
        this.participant = participant;
        this.status = status;
    }

    public String getId() {
        return String.format("%s:%s", this.eventId, this.participant);
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getParticipant() {
        return this.participant;
    }

    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = 31 * result + (this.participant == null ? 0 : this.participant.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invitation other = (Invitation)obj;
        if (this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId)) {
            return false;
        }
        if (this.participant == null ? other.participant != null : !this.participant.equals(other.participant)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public static String[] parse(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id should not be null");
        }
        String[] tmp = id.split(":");
        if (tmp.length != 2) {
            throw new IllegalArgumentException("id should be compose of eventId:participantId");
        }
        return tmp;
    }
}

