/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.admin;

import com.google.caja.util.Maps;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.gadgets.admin.ContainerAdminData;

public class ServerAdminData {
    private Map<String, ContainerAdminData> containerAdminDataMap;

    @Inject
    public ServerAdminData() {
        this(null);
    }

    public ServerAdminData(@Nullable Map<String, ContainerAdminData> containerAdminMap) {
        this.containerAdminDataMap = containerAdminMap != null ? containerAdminMap : Maps.newHashMap();
    }

    public ContainerAdminData getContainerAdminData(String container) {
        container = container != null ? container.toLowerCase() : container;
        return this.containerAdminDataMap.get(container);
    }

    public void removeContainerAdminData(String container) {
        this.containerAdminDataMap.remove(container);
    }

    public void addContainerAdminData(String container, ContainerAdminData toAdd) {
        if (container != null) {
            if (toAdd == null) {
                toAdd = new ContainerAdminData();
            }
            this.containerAdminDataMap.put(container.toLowerCase(), toAdd);
        }
    }

    public Map<String, ContainerAdminData> getContainerAdminDataMap() {
        return this.containerAdminDataMap;
    }

    public void clearContainerAdminData() {
        this.containerAdminDataMap.clear();
    }

    public boolean hasContainerAdminData(String container) {
        container = container != null ? container.toLowerCase() : container;
        return this.containerAdminDataMap.keySet().contains(container);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerAdminData) {
            ServerAdminData test = (ServerAdminData)obj;
            return test.getContainerAdminDataMap().equals(this.containerAdminDataMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.containerAdminDataMap});
    }
}

