/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.http.CacheKeyBuilder;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.uri.UriCommon;

public abstract class AbstractHttpCache
implements HttpCache {
    private static final String RESIZE_HEIGHT = UriCommon.Param.RESIZE_HEIGHT.getKey();
    private static final String RESIZE_WIDTH = UriCommon.Param.RESIZE_WIDTH.getKey();
    private static final String RESIZE_QUALITY = UriCommon.Param.RESIZE_QUALITY.getKey();
    private static final String NO_EXPAND = UriCommon.Param.NO_EXPAND.getKey();
    @Inject(optional=true)
    @Named(value="shindig.cache.http.strict-no-cache-resource.refetch-after-ms")
    public static long REFETCH_STRICT_NO_CACHE_AFTER_MS_DEFAULT = -1L;
    private long refetchStrictNoCacheAfterMs = REFETCH_STRICT_NO_CACHE_AFTER_MS_DEFAULT;

    protected abstract HttpResponse getResponseImpl(String var1);

    protected abstract void addResponseImpl(String var1, HttpResponse var2);

    protected abstract void removeResponseImpl(String var1);

    @Override
    public HttpResponse getResponse(HttpRequest request) {
        String keyString;
        HttpResponse cached;
        if (this.isCacheable(request) && this.responseStillUsable(cached = this.getResponseImpl(keyString = this.createKey(request))) && (!cached.isStrictNoCache() || this.refetchStrictNoCacheAfterMs >= 0L)) {
            return cached;
        }
        return null;
    }

    @Override
    public HttpResponse addResponse(HttpRequest request, HttpResponse response) {
        HttpResponseBuilder responseBuilder;
        boolean storeStrictNoCacheResources;
        boolean bl = storeStrictNoCacheResources = this.refetchStrictNoCacheAfterMs >= 0L;
        if (this.isCacheable(request, response, storeStrictNoCacheResources)) {
            responseBuilder = storeStrictNoCacheResources && response.isStrictNoCache() ? this.buildStrictNoCacheHttpResponse(response) : new HttpResponseBuilder(response);
        } else {
            return null;
        }
        int forcedTtl = request.getCacheTtl();
        if (forcedTtl != -1 && !response.isError()) {
            responseBuilder.setCacheTtl(forcedTtl);
        }
        response = responseBuilder.create();
        String keyString = this.createKey(request);
        this.addResponseImpl(keyString, response);
        return response;
    }

    @VisibleForTesting
    public void setRefetchStrictNoCacheAfterMs(long refetchStrictNoCacheAfterMs) {
        this.refetchStrictNoCacheAfterMs = refetchStrictNoCacheAfterMs;
    }

    @VisibleForTesting
    HttpResponseBuilder buildStrictNoCacheHttpResponse(HttpResponse response) {
        HttpResponseBuilder responseBuilder = new HttpResponseBuilder();
        this.copyHeaderIfPresent("Cache-Control", response, responseBuilder);
        this.copyHeaderIfPresent("Pragma", response, responseBuilder);
        responseBuilder.setRefetchStrictNoCacheAfterMs(this.refetchStrictNoCacheAfterMs);
        return responseBuilder;
    }

    private void copyHeaderIfPresent(String header, HttpResponse response, HttpResponseBuilder builder) {
        String headerValue = response.getHeader(header);
        if (headerValue != null) {
            builder.setHeader(header, headerValue);
        }
    }

    @Override
    public HttpResponse removeResponse(HttpRequest request) {
        String keyString = this.createKey(request);
        HttpResponse response = this.getResponseImpl(keyString);
        this.removeResponseImpl(keyString);
        if (this.responseStillUsable(response)) {
            return response;
        }
        return null;
    }

    protected boolean isCacheable(HttpRequest request) {
        if (request.getIgnoreCache()) {
            return false;
        }
        return "GET".equals(request.getMethod()) || "GET".equals(request.getHeader("X-Method-Override"));
    }

    protected boolean isCacheable(HttpRequest request, HttpResponse response, boolean allowStrictNoCacheResponses) {
        if (!this.isCacheable(request)) {
            return false;
        }
        if (request.getCacheTtl() != -1) {
            return true;
        }
        if (response.getHttpStatusCode() == 304) {
            return false;
        }
        return allowStrictNoCacheResponses || !response.isStrictNoCache();
    }

    @Override
    public String createKey(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getSecurityToken() == null) {
            throw new IllegalArgumentException("Cannot sign request without security token: [" + request + ']');
        }
        CacheKeyBuilder keyBuilder = new CacheKeyBuilder().setLegacyParam(0, request.getUri()).setLegacyParam(1, (Object)request.getAuthType()).setLegacyParam(2, AbstractHttpCache.getOwnerId(request)).setLegacyParam(3, AbstractHttpCache.getViewerId(request)).setLegacyParam(4, AbstractHttpCache.getTokenOwner(request)).setLegacyParam(5, AbstractHttpCache.getAppUrl(request)).setLegacyParam(6, AbstractHttpCache.getInstanceId(request)).setLegacyParam(7, AbstractHttpCache.getServiceName(request)).setLegacyParam(8, AbstractHttpCache.getTokenName(request)).setParam("rh", request.getParam(RESIZE_HEIGHT)).setParam("rw", request.getParam(RESIZE_WIDTH)).setParam("rq", request.getParam(RESIZE_QUALITY)).setParam("ne", request.getParam(NO_EXPAND)).setParam("rm", request.getRewriteMimeType()).setParam("ua", request.getHeader("User-Agent"));
        return keyBuilder.build();
    }

    protected static String getOwnerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getAuthType() != AuthType.OAUTH2 && request.getOAuthArguments().getSignOwner()) {
            Preconditions.checkState((request.getSecurityToken() != null ? 1 : 0) != 0, (Object)"No Security Token set for request");
            String ownerId = request.getSecurityToken().getOwnerId();
            return (String)Objects.firstNonNull((Object)ownerId, (Object)"");
        }
        return null;
    }

    protected static String getViewerId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getAuthType() != AuthType.OAUTH2 && request.getOAuthArguments().getSignViewer()) {
            Preconditions.checkState((request.getSecurityToken() != null ? 1 : 0) != 0, (Object)"No Security Token set for request");
            String viewerId = request.getSecurityToken().getViewerId();
            return (String)Objects.firstNonNull((Object)viewerId, (Object)"");
        }
        return null;
    }

    protected static String getTokenOwner(HttpRequest request) {
        SecurityToken st = request.getSecurityToken();
        if (request.getAuthType() != AuthType.NONE && request.getAuthType() != AuthType.OAUTH2 && st.getOwnerId() != null && st.getOwnerId().equals(st.getViewerId()) && request.getOAuthArguments().mayUseToken()) {
            return st.getOwnerId();
        }
        return null;
    }

    protected static String getAppUrl(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return request.getSecurityToken().getAppUrl();
        }
        return null;
    }

    protected static String getInstanceId(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE) {
            return Long.toString(request.getSecurityToken().getModuleId());
        }
        return null;
    }

    protected static String getServiceName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getAuthType() != AuthType.OAUTH2) {
            return request.getOAuthArguments().getServiceName();
        }
        return null;
    }

    protected static String getTokenName(HttpRequest request) {
        if (request.getAuthType() != AuthType.NONE && request.getAuthType() != AuthType.OAUTH2) {
            return request.getOAuthArguments().getTokenName();
        }
        return null;
    }

    protected boolean responseStillUsable(HttpResponse response) {
        return response != null;
    }
}

