/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.config.ConfigProcessor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsGadgetContext;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class ConfigInjectionProcessor
implements JsProcessor {
    @VisibleForTesting
    static final String GADGETS_FEATURES_KEY = "gadgets.features";
    @VisibleForTesting
    static final String CONFIG_FEATURE = "core.config.base";
    protected static final String CONFIG_GLOBAL_KEY_TPL = "window['___cfg']=%s;\n";
    protected static final String CONFIG_INIT_ID = "[config-injection]";
    protected static final String CONFIG_INIT_TPL = "gadgets.config.init(%s);\n";
    protected static final String CONFIG_INJECT_CODE = "window['___jsl'] = window['___jsl'] || {};(window['___jsl']['ci'] = (window['___jsl']['ci'] || [])).push(%s);";
    private final FeatureRegistryProvider registryProvider;
    private final ConfigProcessor configProcessor;

    @Inject
    public ConfigInjectionProcessor(FeatureRegistryProvider registryProvider, ConfigProcessor configProcessor) {
        this.registryProvider = registryProvider;
        this.configProcessor = configProcessor;
    }

    @Override
    public boolean process(JsRequest request, JsResponseBuilder builder) throws JsException {
        FeatureRegistry registry;
        JsUriManager.JsUri jsUri = request.getJsUri();
        JsGadgetContext ctx = new JsGadgetContext(jsUri);
        try {
            registry = this.registryProvider.get(jsUri.getRepository());
        }
        catch (GadgetException e) {
            throw new JsException(e.getHttpStatusCode(), e.getMessage());
        }
        if (((GadgetContext)ctx).getRenderingContext() != RenderingContext.GADGET) {
            List<String> allReq = registry.getFeatures(jsUri.getLibs());
            Collection<String> loaded = jsUri.getLoadedLibs();
            List<String> newReq = this.subtractCollection(allReq, loaded);
            Map<String, Object> config = this.configProcessor.getConfig(((GadgetContext)ctx).getContainer(), newReq, request.getHost(), null);
            if (!config.isEmpty()) {
                String configJson = JsonSerializer.serialize(config);
                if (allReq.contains(CONFIG_FEATURE) || loaded.contains(CONFIG_FEATURE)) {
                    this.injectBaseConfig(configJson, builder);
                } else {
                    this.injectGlobalConfig(configJson, builder);
                }
            }
        }
        return true;
    }

    protected void injectBaseConfig(String configJson, JsResponseBuilder builder) {
        builder.prependJs(String.format(CONFIG_INJECT_CODE, configJson), CONFIG_INIT_ID);
        builder.appendJs(String.format(CONFIG_INIT_TPL, configJson), CONFIG_INIT_ID);
    }

    protected void injectGlobalConfig(String configJson, JsResponseBuilder builder) {
        builder.appendJs(String.format(CONFIG_GLOBAL_KEY_TPL, configJson), CONFIG_INIT_ID);
    }

    private List<String> subtractCollection(Collection<String> root, Collection<String> subtracted) {
        HashSet result = Sets.newHashSet(root);
        result.removeAll(subtracted);
        return Lists.newArrayList((Iterable)result);
    }
}

