/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shindig.common.xml.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalServices {
    private static final String ATTR_ALIAS = "alias";
    private Map<String, ServiceTag> serviceTags;

    public ExternalServices(Element element) {
        LinkedHashMap serviceTagsBuilder = Maps.newLinkedHashMap();
        this.parseServiceTags(element, serviceTagsBuilder);
        this.serviceTags = ImmutableMap.copyOf((Map)serviceTagsBuilder);
    }

    public Map<String, ServiceTag> getServiceTags() {
        return this.serviceTags;
    }

    private void parseServiceTags(Element element, Map<String, ServiceTag> serviceTagsBuilder) {
        NodeList children = element.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            String tagName = child.getNodeName();
            if (!(child instanceof Element) || !"ServiceTag".equals(tagName)) continue;
            String alias = XmlUtil.getAttribute((Node)child, (String)ATTR_ALIAS, (String)"");
            String tag = child.getTextContent();
            tag = tag != null ? tag.trim() : "";
            ServiceTag serviceTag = new ServiceTag(alias, tag);
            serviceTagsBuilder.put(alias, serviceTag);
        }
    }

    public static class ServiceTag {
        public static final String SERVICE_TAG = "ServiceTag";
        private final String alias;
        private final String tag;

        public ServiceTag(String alias, String tag) {
            this.alias = alias;
            this.tag = tag;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

