/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.ProfileFilterListAccess;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileLifeCycle;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.webui.exception.MessageException;

public class IdentityManagerImpl
implements IdentityManager {
    private static final Log LOG = ExoLogger.getExoLogger(IdentityManagerImpl.class);
    private static final int OFFSET = 0;
    private static final int LIMIT = 200;
    protected Map<String, IdentityProvider<?>> identityProviders = new HashMap();
    protected Map<String, ProfileListener> profileListeners = new HashMap<String, ProfileListener>();
    protected IdentityStorage identityStorage;
    protected RelationshipManager relationshipManager;
    protected ProfileLifeCycle profileLifeCycle = new ProfileLifeCycle();
    private Sorting defaultSorting = DEFAULT_SORTING;
    private String firstCharacterFiltering = DEFAULT_FIRST_CHAR_FILTERING;

    public IdentityManagerImpl(IdentityStorage identityStorage, IdentityProvider<?> defaultIdentityProvider, InitParams initParams) {
        this.identityStorage = identityStorage;
        this.addIdentityProvider(defaultIdentityProvider);
        if (initParams != null) {
            Sorting configuredSorting;
            String sortFieldName = this.defaultSorting.sortBy.getFieldName();
            if (initParams.containsKey((Object)"sort.field.name")) {
                sortFieldName = initParams.getValueParam("sort.field.name").getValue();
            }
            String sortDirection = this.defaultSorting.orderBy.name();
            if (initParams.containsKey((Object)"sort.order.direction")) {
                sortDirection = initParams.getValueParam("sort.order.direction").getValue();
            }
            if ((configuredSorting = Sorting.valueOf(sortFieldName, sortDirection)) != null) {
                this.defaultSorting = configuredSorting;
            }
            String firstCharacterFilteringField = DEFAULT_FIRST_CHAR_FILTERING;
            if (initParams.containsKey((Object)"firstChar.field.name")) {
                firstCharacterFilteringField = initParams.getValueParam("firstChar.field.name").getValue();
            }
            if ((configuredSorting = Sorting.valueOf(firstCharacterFilteringField, "ASC")) != null && configuredSorting.sortBy != null) {
                this.firstCharacterFiltering = configuredSorting.sortBy.getFieldName();
            }
        }
    }

    @Override
    public Sorting getDefaultSorting() {
        return this.defaultSorting;
    }

    @Override
    public String getFirstCharacterFiltering() {
        return this.firstCharacterFiltering;
    }

    @Override
    public List<Identity> getLastIdentities(int limit) {
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setSorting(new Sorting(Sorting.SortBy.DATE, Sorting.OrderBy.DESC));
        return this.identityStorage.getIdentitiesForUnifiedSearch("organization", profileFilter, 0L, limit);
    }

    @Override
    public ListAccess<Identity> getConnectionsWithListAccess(Identity identity) {
        return this.getRelationshipManager().getConnections(identity);
    }

    @Override
    public ListAccess<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, boolean forceLoadProfile) {
        if (profileFilter == null) {
            profileFilter = new ProfileFilter();
        }
        if (profileFilter.isSortingEmpty()) {
            profileFilter.setSorting(this.defaultSorting);
        }
        if (StringUtils.isBlank((CharSequence)profileFilter.getFirstCharFieldName())) {
            profileFilter.setFirstCharFieldName(this.firstCharacterFiltering);
        }
        return new ProfileFilterListAccess(this.identityStorage, providerId, profileFilter, forceLoadProfile);
    }

    @Override
    public ListAccess<Identity> getSpaceIdentityByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, boolean forceLoadProfile) {
        return new SpaceMemberFilterListAccess(this.identityStorage, space, profileFilter, type);
    }

    @Override
    public Profile getProfile(Identity identity) {
        Profile profile = identity.getProfile();
        if (profile.getId() == null) {
            profile = this.identityStorage.loadProfile(profile);
            identity.setProfile(profile);
        }
        return profile;
    }

    @Override
    public InputStream getAvatarInputStream(Identity identity) throws IOException {
        if (identity == null) {
            return null;
        }
        return this.identityStorage.getAvatarInputStreamById(identity);
    }

    @Override
    public InputStream getBannerInputStream(Identity identity) throws IOException {
        if (identity == null) {
            return null;
        }
        return this.identityStorage.getBannerInputStreamById(identity);
    }

    @Override
    public void updateProfile(Profile existingProfile) throws MessageException {
        this.identityStorage.updateProfile(existingProfile);
        this.broadcastUpdateProfileEvent(existingProfile);
        this.getIdentityProvider(existingProfile.getIdentity().getProviderId()).onUpdateProfile(existingProfile);
    }

    @Override
    public void registerProfileListener(ProfileListenerPlugin profileListenerPlugin) {
        this.profileLifeCycle.addListener(profileListenerPlugin);
    }

    @Override
    public Identity updateIdentity(Identity identity) {
        return this.identityStorage.updateIdentity(identity);
    }

    @Override
    public void addIdentityProvider(IdentityProvider<?> idProvider) {
        if (idProvider != null) {
            LOG.debug((Object)("Registering identity provider for " + idProvider.getName() + ": " + idProvider));
            this.identityProviders.put(idProvider.getName(), idProvider);
        }
    }

    @Override
    public void removeIdentityProvider(IdentityProvider<?> identityProvider) {
        if (identityProvider != null) {
            LOG.debug((Object)("Removing identity provider for " + identityProvider.getName() + ": " + identityProvider));
            this.identityProviders.remove(identityProvider.getName());
        }
    }

    @Override
    public void deleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().deleteIdentity(identity);
    }

    @Override
    public void hardDeleteIdentity(Identity identity) {
        if (identity.getId() == null) {
            LOG.warn((Object)("identity.getId() must not be null of [" + identity + "]"));
            return;
        }
        this.getIdentityStorage().hardDeleteIdentity(identity);
    }

    @Override
    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        return Arrays.asList(this.getConnectionsWithListAccess(ownerIdentity).load(0, 200));
    }

    @Override
    public List<Identity> getIdentities(String providerId) throws Exception {
        return this.getIdentities(providerId, true);
    }

    @Override
    public List<Identity> getIdentities(String providerId, boolean loadProfile) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(providerId, new ProfileFilter(), loadProfile).load(0, 200));
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load(0, 200));
    }

    @Override
    public ListAccess<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter) {
        return new ProfileFilterListAccess(this.identityStorage, providerId, profileFilter, true, ProfileFilterListAccess.Type.UNIFIED_SEARCH);
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load((int)offset, (int)limit));
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(null, profileFilter, false).load(0, 200));
    }

    @Override
    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(null, profileFilter, false).load((int)offset, (int)limit));
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load(0, 200));
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(providerId, profileFilter, false).load((int)offset, (int)limit));
    }

    @Override
    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        return Arrays.asList(this.getIdentitiesByProfileFilter(null, profileFilter, false).load(0, 200));
    }

    @Override
    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    @Override
    public long getIdentitiesCount(String providerId) {
        return this.identityStorage.getIdentitiesCount(providerId);
    }

    @Override
    public Identity getIdentity(String identityId, boolean forceLoadOrReloadProfile) {
        Identity returnIdentity = this.getIdentityStorage().findIdentityById(identityId);
        if (returnIdentity != null) {
            if (forceLoadOrReloadProfile) {
                Profile profile = this.getIdentityStorage().loadProfile(returnIdentity.getProfile());
                returnIdentity.setProfile(profile);
            }
        } else {
            LOG.info((Object)("Can not get identity with id: " + identityId));
        }
        return returnIdentity;
    }

    @Override
    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        return this.getOrCreateIdentity(providerId, remoteId, loadProfile);
    }

    @Override
    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean forceLoadOrReloadProfile) {
        Identity returnIdentity = null;
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        Identity identityFoundByRemoteProvider = identityProvider.getIdentityByRemoteId(remoteId);
        Identity result = this.getIdentityStorage().findIdentity(providerId, remoteId);
        if (result == null) {
            if (identityFoundByRemoteProvider == null) return result;
            this.saveIdentity(identityFoundByRemoteProvider);
            this.getIdentityStorage().saveProfile(identityFoundByRemoteProvider.getProfile());
            result = identityFoundByRemoteProvider;
            if (!"organization".equals(providerId)) return result;
            this.profileLifeCycle.createProfile(result.getProfile());
            return result;
        } else {
            if (identityFoundByRemoteProvider == null && !result.isDeleted()) {
                LOG.warn((Object)("User " + remoteId + " not found in remote provider " + providerId + " but his social identity is not marked as deleted"), (Throwable)new IllegalStateException("User '" + remoteId + "' should be marked as deleted since it wasn't found in IDM store"));
            }
            if (!forceLoadOrReloadProfile) return result;
            Profile profile = this.getIdentityStorage().loadProfile(result.getProfile());
            result.setProfile(profile);
        }
        return result;
    }

    @Override
    public boolean identityExisted(String providerId, String remoteId) {
        IdentityProvider<?> identityProvider = this.getIdentityProvider(providerId);
        return identityProvider.getIdentityByRemoteId(remoteId) != null;
    }

    @Override
    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
        List<IdentityProvider<?>> pluginProviders = plugin.getProviders();
        if (pluginProviders != null) {
            for (IdentityProvider<?> identityProvider : pluginProviders) {
                this.addIdentityProvider(identityProvider);
            }
        }
    }

    @Override
    public void saveIdentity(Identity identity) {
        this.getIdentityStorage().saveIdentity(identity);
        this.getIdentityProvider(identity.getProviderId()).onSaveIdentity(identity);
    }

    @Override
    public void saveProfile(Profile profile) {
        this.getIdentityStorage().saveProfile(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    @Override
    public void updateAvatar(Profile p) throws MessageException {
        this.updateProfile(p);
    }

    @Override
    public void updateBasicInfo(Profile p) throws Exception {
        this.updateProfile(p);
    }

    @Override
    public void updateContactSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    @Override
    public void updateExperienceSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    @Override
    public void updateHeaderSection(Profile p) throws Exception {
        this.updateProfile(p);
    }

    public IdentityProvider<?> getIdentityProvider(String providerId) {
        IdentityProvider<?> provider = this.identityProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("No suitable identity provider exists for " + providerId);
        }
        return provider;
    }

    @Override
    public IdentityStorage getIdentityStorage() {
        return this.identityStorage;
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    public RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            this.relationshipManager = (RelationshipManager)PortalContainer.getInstance().getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    @Override
    public void addProfileListener(ProfileListenerPlugin plugin) {
        this.registerProfileListener(plugin);
    }

    @Override
    public void registerProfileListener(ProfileListener listener) {
        this.profileLifeCycle.addListener(listener);
    }

    @Override
    public void unregisterProfileListener(ProfileListener listener) {
        this.profileLifeCycle.removeListener(listener);
    }

    @Override
    public void addOrModifyProfileProperties(Profile profile) throws Exception {
        this.getIdentityStorage().addOrModifyProfileProperties(profile);
        this.getIdentityProvider(profile.getIdentity().getProviderId()).onSaveProfile(profile);
    }

    @Override
    public IdentityStorage getStorage() {
        return this.identityStorage;
    }

    protected void broadcastUpdateProfileEvent(Profile profile) {
        for (Profile.UpdateType type : profile.getListUpdateTypes()) {
            type.updateActivity(this.profileLifeCycle, profile);
        }
    }

    @Override
    public void processEnabledIdentity(String remoteId, boolean isEnable) {
        Identity identity = this.getOrCreateIdentity("organization", remoteId, false);
        this.getIdentityStorage().processEnabledIdentity(identity, isEnable);
    }

    @Override
    public List<String> sortIdentities(List<String> identityRemoteIds, String firstCharacterFieldName, char firstCharacter, String sortField, String sortDirection) {
        if (StringUtils.isBlank((CharSequence)firstCharacterFieldName)) {
            firstCharacterFieldName = this.getFirstCharacterFiltering();
        }
        if (StringUtils.isBlank((CharSequence)sortField)) {
            sortField = this.getDefaultSorting().sortBy.getFieldName();
        }
        if (StringUtils.isBlank((CharSequence)sortDirection)) {
            sortDirection = this.getDefaultSorting().orderBy.name();
        }
        return this.identityStorage.sortIdentities(identityRemoteIds, firstCharacterFieldName, firstCharacter, sortField, sortDirection);
    }
}

