/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.social.core.chromattic.entity.RelationshipEntity;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.updater.AbstractMigrationService;
import org.exoplatform.social.core.jpa.updater.MigrationContext;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

@Managed
@ManagedDescription(value="Social migration relationships from JCR to RDBMS.")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="migration-relationships")})
public class RelationshipMigrationService
extends AbstractMigrationService<Relationship> {
    public static final String EVENT_LISTENER_KEY = "SOC_RELATIONSHIP_MIGRATION";
    private final ConnectionDAO connectionDAO;
    private final IdentityDAO identityDAO;
    private static final int LIMIT_REMOVED_THRESHOLD = 10;
    private Set<String> identitiesMigrateFailed = new HashSet<String>();
    private Set<String> identitiesCleanupFailed = new HashSet<String>();

    public RelationshipMigrationService(InitParams initParams, IdentityStorageImpl identityStorage, ConnectionDAO connectionDAO, IdentityDAO identityDAO, EventManager<Relationship, String> eventManager, EntityManagerService entityManagerService) {
        super(initParams, identityStorage, eventManager, entityManagerService);
        this.connectionDAO = connectionDAO;
        this.identityDAO = identityDAO;
        this.LIMIT_THRESHOLD = this.getInteger(initParams, "LIMIT_THRESHOLD", 200);
    }

    @Override
    protected void beforeMigration() throws Exception {
        MigrationContext.setConnectionDone(false);
        this.identitiesMigrateFailed = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    @ManagedDescription(value="Manual to start run migration data of relationships from JCR to RDBMS.")
    public void doMigration() throws Exception {
        RequestLifeCycle.end();
        long totalIdentities = this.getNumberUserIdentities();
        boolean cont = true;
        long offset = 0L;
        int total = 0;
        long t = System.currentTimeMillis();
        while (cont && !this.forceStop) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            boolean begunTx = this.startTx();
            ArrayList<String> transactionList = new ArrayList<String>();
            try {
                this.LOG.info((Object)"| \\ START::Relationships migration ---------------------------------");
                NodeIterator nodeIter = this.getIdentityNodes(offset, this.LIMIT_THRESHOLD);
                if (nodeIter == null || nodeIter.getSize() == 0L) {
                    cont = false;
                    continue;
                }
                while (nodeIter.hasNext() && !this.forceStop) {
                    int relationshipNo = 0;
                    Node identityNode = nodeIter.nextNode();
                    String identityName = identityNode.getName();
                    transactionList.add(identityName);
                    this.LOG.info((Object)String.format("|  \\ START::user number: %s/%s (%s user)", ++offset, totalIdentities, identityNode.getName()));
                    long t1 = System.currentTimeMillis();
                    try {
                        long size;
                        NodeIterator rIt;
                        Node relationshipNode = identityNode.getNode("soc:relationship");
                        if (relationshipNode != null) {
                            rIt = relationshipNode.getNodes();
                            size = rIt.getSize();
                            this.LOG.info((Object)("|     - CONFIRMED:: size = " + size));
                            if (size > 0L) {
                                relationshipNo += this.migrateRelationshipEntity(rIt, identityNode.getName(), false, Relationship.Type.CONFIRMED);
                            }
                        }
                        if ((relationshipNode = identityNode.getNode("soc:sender")) != null) {
                            rIt = relationshipNode.getNodes();
                            size = rIt.getSize();
                            this.LOG.info((Object)("|     - SENDER:: size = " + size));
                            if (size > 0L) {
                                relationshipNo += this.migrateRelationshipEntity(rIt, identityNode.getName(), false, Relationship.Type.OUTGOING);
                            }
                        }
                        if ((relationshipNode = identityNode.getNode("soc:receiver")) != null) {
                            rIt = relationshipNode.getNodes();
                            size = rIt.getSize();
                            this.LOG.info((Object)("|     - RECEIVER:: size = " + size));
                            if (size > 0L) {
                                relationshipNo += this.migrateRelationshipEntity(rIt, identityNode.getName(), true, Relationship.Type.INCOMING);
                            }
                        }
                        org.exoplatform.social.core.chromattic.entity.IdentityEntity identityEntity = (org.exoplatform.social.core.chromattic.entity.IdentityEntity)this._findById(org.exoplatform.social.core.chromattic.entity.IdentityEntity.class, identityNode.getUUID());
                        identityEntity.setProperty("connection_migrated", "true");
                    }
                    catch (Exception ex) {
                        this.LOG.error((Object)("Exception while migrate relationship for " + identityName), (Throwable)ex);
                        this.identitiesMigrateFailed.add(identityName);
                    }
                    total += relationshipNo;
                    if (offset % (long)this.LIMIT_THRESHOLD == 0L) {
                        try {
                            this.endTx(begunTx);
                        }
                        catch (Exception ex) {
                            this.identitiesMigrateFailed.addAll(transactionList);
                        }
                        RequestLifeCycle.end();
                        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                        begunTx = this.startTx();
                        transactionList = new ArrayList();
                        nodeIter = this.getIdentityNodes(offset, this.LIMIT_THRESHOLD);
                    }
                    this.LOG.info((Object)String.format("|  / END::user number %s (%s user) with %s relationship(s) user consumed %s(ms)", relationshipNo, identityNode.getName(), relationshipNo, System.currentTimeMillis() - t1));
                }
            }
            finally {
                try {
                    this.endTx(begunTx);
                }
                catch (Exception ex) {
                    this.identitiesMigrateFailed.addAll(transactionList);
                }
                RequestLifeCycle.end();
            }
        }
        this.LOG.info((Object)String.format("| / END::Relationships migration for (%s) user(s) with %s relationship(s) consumed %s(ms)", offset, total, System.currentTimeMillis() - t));
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        this.LOG.info((Object)"| \\ START::Re-indexing identity(s) ---------------------------------");
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        indexingService.reindexAll("profile");
        this.LOG.info((Object)"| / END::Re-indexing identity(s) ---------------------------------");
    }

    private int migrateRelationshipEntity(NodeIterator it, String userName, boolean isIncoming, Relationship.Type status) throws RepositoryException {
        int doneConnectionNo = 0;
        this.startTx();
        while (it.hasNext()) {
            block5: {
                Node relationshipNode = it.nextNode();
                String receiverId = relationshipNode.getProperty("soc:to").getString();
                this.LOG.debug((Object)("|     - FROM ID = " + receiverId));
                String senderId = relationshipNode.getProperty("soc:from").getString();
                this.LOG.debug((Object)("|     - TO ID = " + senderId));
                long lastUpdated = System.currentTimeMillis();
                if (relationshipNode.hasProperty("exo:lastModifiedDate")) {
                    lastUpdated = relationshipNode.getProperty("exo:lastModifiedDate").getDate().getTimeInMillis();
                }
                this.LOG.debug((Object)("|     - LAST UPDATED = " + lastUpdated));
                try {
                    org.exoplatform.social.core.chromattic.entity.IdentityEntity senderIdentity = (org.exoplatform.social.core.chromattic.entity.IdentityEntity)this._findById(org.exoplatform.social.core.chromattic.entity.IdentityEntity.class, senderId);
                    org.exoplatform.social.core.chromattic.entity.IdentityEntity receiverIdentity = (org.exoplatform.social.core.chromattic.entity.IdentityEntity)this._findById(org.exoplatform.social.core.chromattic.entity.IdentityEntity.class, receiverId);
                    IdentityEntity sender = this.identityDAO.findByProviderAndRemoteId("organization", senderIdentity.getRemoteId());
                    IdentityEntity receiver = this.identityDAO.findByProviderAndRemoteId("organization", receiverIdentity.getRemoteId());
                    ConnectionEntity exist = this.connectionDAO.getConnection(sender.getId(), receiver.getId());
                    if (exist == null) {
                        exist = this.connectionDAO.getConnection(receiver.getId(), sender.getId());
                    }
                    if (exist != null) break block5;
                    ConnectionEntity entity = new ConnectionEntity(sender, receiver);
                    entity.setStatus(status);
                    entity.setUpdatedDate(new Date(lastUpdated));
                    this.connectionDAO.create(entity);
                    ++doneConnectionNo;
                }
                catch (Exception e) {
                    this.LOG.warn((Object)e.getMessage());
                    continue;
                }
            }
            if (doneConnectionNo % this.LIMIT_THRESHOLD != 0) continue;
            this.LOG.info((Object)String.format("|     - BATCH MIGRATION::relationship number: %s (%s user)", doneConnectionNo, userName));
            this.endTx(true);
            this.entityManagerService.endRequest((ExoContainer)PortalContainer.getInstance());
            this.entityManagerService.startRequest((ExoContainer)PortalContainer.getInstance());
            this.startTx();
        }
        return doneConnectionNo;
    }

    @Override
    protected void afterMigration() throws Exception {
        MigrationContext.setIdentitiesMigrateConnectionFailed(this.identitiesMigrateFailed);
        if (!this.forceStop && this.identitiesMigrateFailed.isEmpty()) {
            MigrationContext.setConnectionDone(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemove() throws Exception {
        this.identitiesCleanupFailed = new HashSet<String>();
        long totalIdentities = this.getNumberUserIdentities();
        this.LOG.info((Object)"| \\ START::cleanup Relationships ---------------------------------");
        long t = System.currentTimeMillis();
        long timePerUser = System.currentTimeMillis();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        int offset = 0;
        ArrayList<String> transactionList = new ArrayList<String>();
        try {
            NodeIterator nodeIter = this.getIdentityNodes(offset, this.LIMIT_THRESHOLD);
            transactionList = new ArrayList();
            if (nodeIter == null || nodeIter.getSize() == 0L) {
                return;
            }
            Node node = null;
            while (nodeIter.hasNext()) {
                node = nodeIter.nextNode();
                String name = node.getName();
                if (!MigrationContext.isForceCleanup() && MigrationContext.getIdentitiesMigrateConnectionFailed().contains(name)) {
                    this.identitiesCleanupFailed.add(name);
                    continue;
                }
                transactionList.add(node.getName());
                this.LOG.info((Object)String.format("|  \\ START::cleanup Relationship of user number: %s/%s (%s user)", ++offset, totalIdentities, node.getName()));
                org.exoplatform.social.core.chromattic.entity.IdentityEntity identityEntity = (org.exoplatform.social.core.chromattic.entity.IdentityEntity)this._findById(org.exoplatform.social.core.chromattic.entity.IdentityEntity.class, node.getUUID());
                String migrated = identityEntity.getProperty("connection_migrated");
                if (!"true".equalsIgnoreCase(migrated)) {
                    this.identitiesCleanupFailed.add(name);
                    this.LOG.warn((Object)("Can not clean connection for " + name + " due to migration was not successful"));
                    continue;
                }
                Collection<Object> entities = identityEntity.getRelationship().getRelationships().values();
                this.removeRelationshipEntity(entities);
                entities = identityEntity.getSender().getRelationships().values();
                this.removeRelationshipEntity(entities);
                entities = identityEntity.getReceiver().getRelationships().values();
                this.removeRelationshipEntity(entities);
                this.LOG.info((Object)String.format("|  / END::cleanup (%s user) consumed time %s(ms)", node.getName(), System.currentTimeMillis() - timePerUser));
                timePerUser = System.currentTimeMillis();
                if (offset % this.LIMIT_THRESHOLD != 0) continue;
                try {
                    this.getSession().save();
                }
                catch (Exception ex) {
                    this.LOG.error((Object)"Failed when commit the cleanup connections", (Throwable)ex);
                    this.identitiesCleanupFailed.addAll(transactionList);
                }
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                nodeIter = this.getIdentityNodes(offset, this.LIMIT_THRESHOLD);
                transactionList = new ArrayList();
            }
            this.LOG.info((Object)String.format("| / END::cleanup Relationships migration for (%s) user consumed %s(ms)", offset, System.currentTimeMillis() - t));
        }
        finally {
            try {
                this.getSession().save();
            }
            catch (Exception ex) {
                this.LOG.error((Object)"Failed when commit the cleanup connections", (Throwable)ex);
                this.identitiesCleanupFailed.addAll(transactionList);
            }
            RequestLifeCycle.end();
            MigrationContext.setIdentitiesCleanupConnectionFailed(this.identitiesCleanupFailed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRelationshipEntity(Collection<RelationshipEntity> entities) {
        try {
            int offset = 0;
            for (RelationshipEntity relationshipEntity : entities) {
                this.getSession().remove((Object)relationshipEntity);
                if (++offset % 10 != 0) continue;
                this.LOG.info((Object)String.format("|     - BATCH CLEANUP::relationship number: %s", offset));
                this.getSession().save();
            }
        }
        finally {
            this.getSession().save();
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="Manual to stop run miguration data of relationships from JCR to RDBMS.")
    public void stop() {
        super.stop();
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }
}

