/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UIAllItems;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDrivesArea.gtmpl", events={@EventConfig(listeners={SelectDriveActionListener.class})})
public class UIDrivesArea
extends UIContainer {
    public static final String FIELD_SELECTREPO = "selectRepo";
    private boolean firstVisit = true;
    private List<String> userRoles_ = null;

    public void setFirstVisit(boolean firstVisit) {
        this.firstVisit = firstVisit;
    }

    public boolean isFirstVisit() {
        return this.firstVisit;
    }

    public String getLabel(String id) {
        PortalRequestContext ctx;
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String userDisplayName = "";
        if ("User Documents".equals(id) && (ctx = Util.getPortalRequestContext()) != null) {
            String username = ctx.getRemoteUser();
            try {
                User user = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getUserHandler().findUserByName(username);
                if (user != null) {
                    userDisplayName = user.getDisplayName();
                }
            }
            catch (Exception ex) {
                userDisplayName = username;
            }
        }
        try {
            return res.getString("Drives.label." + id.replace(" ", "")).replace("{0}", userDisplayName);
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }

    public String getGroupLabel(DriveData driveData) {
        try {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
            String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
            Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), repoService.getCurrentRepository()).getItem(groupPath + driveData.getName().replace(".", "/"));
            return groupNode.getProperty("exo:driveLabel").getString();
        }
        catch (Exception e) {
            return driveData.getName().replace(".", " / ");
        }
    }

    public String getGroupLabel(String groupId, boolean isFull) {
        String ret = groupId.replace(".", " / ");
        if (!isFull) {
            if (ret.startsWith(" / spaces")) {
                return ret.substring(ret.lastIndexOf("/") + 1).trim();
            }
            int count = 0;
            int slashPosition = -1;
            for (int i = 0; i < ret.length(); ++i) {
                if ('/' != ret.charAt(i) || ++count != 4) continue;
                slashPosition = i;
                break;
            }
            if (slashPosition > 0) {
                ret = ret.substring(0, slashPosition) + "...";
            } else if (ret.length() > 70) {
                ret = ret.substring(0, 70) + "...";
            }
        }
        return ret;
    }

    public String getPortalName() {
        PortalContainerInfo containerInfo = (PortalContainerInfo)WCMCoreUtils.getService(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRestName() {
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)this.getApplicationComponent(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(this.getPortalName());
    }

    private List<String> getUserRoles(boolean newRoleUpdated) throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        if (this.userRoles_ == null || this.userRoles_ != null && newRoleUpdated) {
            this.userRoles_ = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
            if (newRoleUpdated) {
                driveService.setNewRoleUpdated(false);
            }
        }
        return this.userRoles_;
    }

    public List<DriveData> mainDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List<String> userRoles = this.getUserRoles(false);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getMainDrives(userId, userRoles).stream().peek(x -> x.setLabel(this.getLabel(x.getName()))).sorted(Comparator.comparing(DriveData::getLabel)).collect(Collectors.toList());
    }

    public List<DriveData> groupDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List<String> userRoles = this.getUserRoles(driveService.newRoleUpdated());
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getGroupDrives(userId, userRoles).stream().peek(x -> x.setLabel(this.getGroupLabel((DriveData)x))).sorted(Comparator.comparing(DriveData::getLabel)).collect(Collectors.toList());
    }

    public List<DriveData> personalDrives() throws Exception {
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return driveService.getPersonalDrives(userId).stream().peek(x -> x.setLabel(this.getLabel(x.getName()))).sorted(Comparator.comparing(DriveData::getLabel)).collect(Collectors.toList());
    }

    public static class SelectDriveActionListener
    extends EventListener<UIDrivesArea> {
        public void execute(Event<UIDrivesArea> event) throws Exception {
            UIDrivesArea uiDrivesArea = (UIDrivesArea)((Object)event.getSource());
            String driveName = event.getRequestContext().getRequestParameter("objectId");
            RepositoryService rservice = (RepositoryService)uiDrivesArea.getApplicationComponent(RepositoryService.class);
            ManageDriveService dservice = (ManageDriveService)uiDrivesArea.getApplicationComponent(ManageDriveService.class);
            DriveData drive = dservice.getDriveByName(driveName);
            String userId = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)uiDrivesArea.getAncestorOfType(UIApplication.class);
            ArrayList<String> viewList = new ArrayList<String>();
            for (Object role : org.exoplatform.ecm.webui.utils.Utils.getMemberships()) {
                for (String viewName : drive.getViews().split(",")) {
                    if (viewList.contains(viewName.trim())) continue;
                    Node viewNode = ((ManageViewService)uiDrivesArea.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), WCMCoreUtils.getSystemSessionProvider());
                    String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                    if (permiss.contains("${userId}")) {
                        permiss = permiss.replace("${userId}", userId);
                    }
                    String[] viewPermissions = permiss.split(",");
                    if (permiss.equals("*")) {
                        viewList.add(viewName.trim());
                    }
                    if (!drive.hasPermission(viewPermissions, (String)role)) continue;
                    viewList.add(viewName.trim());
                }
            }
            if (viewList.isEmpty()) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.no-view-found", args));
                return;
            }
            StringBuffer viewListStr = new StringBuffer();
            for (String viewName : viewList) {
                if (viewListStr.length() > 0) {
                    viewListStr.append(",").append(viewName);
                    continue;
                }
                viewListStr.append(viewName);
            }
            drive.setViews(viewListStr.toString());
            String homePath = drive.getHomePath();
            if (homePath.contains("${userId}")) {
                homePath = Utils.getPersonalDrivePath((String)homePath, (String)userId);
                if (drive.getParameters().get("userId") == null) {
                    drive.getParameters().put("userId", homePath);
                }
            }
            UIJCRExplorerPortlet uiParent = (UIJCRExplorerPortlet)uiDrivesArea.getAncestorOfType(UIJCRExplorerPortlet.class);
            uiParent.setFlagSelect(true);
            UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)uiParent.getChild(UIJcrExplorerContainer.class);
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            UITreeExplorer uiTreeExplorer = (UITreeExplorer)uiJCRExplorer.findFirstComponentOfType(UITreeExplorer.class);
            Preference pref = uiJCRExplorer.getPreference();
            if (!pref.isShowSideBar()) {
                pref.setShowSideBar(drive.getViewSideBar());
            }
            pref.setShowPreferenceDocuments(drive.getViewPreferences());
            pref.setAllowCreateFoder(drive.getAllowCreateFolders());
            HttpServletRequest request = Util.getPortalRequestContext().getRequest();
            Cookie[] cookies = request.getCookies();
            Cookie getCookieForUser = UIJCRExplorer.getCookieByCookieName("isShowHiddenNode", cookies);
            if (uiJCRExplorer.findFirstComponentOfType(UIAllItems.class) == null || getCookieForUser == null) {
                pref.setShowHiddenNode(drive.getShowHiddenNode());
            }
            if (getCookieForUser == null) {
                pref.setShowNonDocumentType(drive.getViewNonDocument());
            }
            uiJCRExplorer.setDriveData(drive);
            uiJCRExplorer.setIsReferenceNode(false);
            uiJCRExplorer.setPreferencesSaved(true);
            uiJCRExplorer.clearTagSelection();
            ManageableRepository repository = rservice.getCurrentRepository();
            try {
                Session session = WCMCoreUtils.getUserSessionProvider().getSession(drive.getWorkspace(), repository);
                session.getItem(homePath);
            }
            catch (AccessDeniedException ace) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.access-denied", args, 1));
                return;
            }
            catch (NoSuchWorkspaceException nosuchWS) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesArea.msg.workspace-not-exist", args, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiJCRExplorer.clearNodeHistory(homePath);
            uiJCRExplorer.setRepositoryName(repository.getConfiguration().getName());
            uiJCRExplorer.setWorkspaceName(drive.getWorkspace());
            uiJCRExplorer.setRootPath(homePath);
            uiJCRExplorer.setSelectNode(drive.getWorkspace(), homePath);
            String selectedView = (String)viewList.get(0);
            UIControl uiControl = (UIControl)((UIControl)uiJCRExplorer.getChild(UIControl.class)).setRendered(true);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiJCRExplorer.getChild(UIWorkingArea.class);
            UIActionBar uiActionbar = (UIActionBar)uiWorkingArea.getChild(UIActionBar.class);
            uiActionbar.setTabOptions(selectedView);
            UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
            uiAddressBar.setViewList(viewList);
            uiAddressBar.setSelectedViewName(selectedView);
            ((UISideBar)uiWorkingArea.getChild(UISideBar.class)).initialize();
            for (UIComponent uiComp : uiWorkingArea.getChildren()) {
                if (uiComp instanceof UIDrivesArea) {
                    uiComp.setRendered(false);
                    continue;
                }
                uiComp.setRendered(true);
            }
            UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
            UIDocumentFormController controller = (UIDocumentFormController)uiDocumentWorkspace.removeChild(UIDocumentFormController.class);
            AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
            if (controller != null) {
                ((UIDocumentForm)controller.getChild(UIDocumentForm.class)).releaseLock();
            }
            uiParent.setRenderedChild(UIJcrExplorerContainer.class);
            event.getRequestContext().getJavascriptManager().require("SHARED/multiUpload", "multiUpload").addScripts("multiUpload.setLocation('" + uiJCRExplorer.getWorkspaceName() + "','" + uiJCRExplorer.getDriveData().getName() + "','" + uiTreeExplorer.getLabel() + "','" + uiJCRExplorer.getCurrentPath() + "','" + Utils.getPersonalDrivePath((String)uiJCRExplorer.getDriveData().getHomePath(), (String)ConversationState.getCurrent().getIdentity().getUserId()) + "', '" + autoVersionService.isVersionSupport(uiJCRExplorer.getCurrentPath(), uiJCRExplorer.getCurrentWorkspace()) + "');");
            ((UIDocumentInfo)uiJCRExplorer.findFirstComponentOfType(UIDocumentInfo.class)).getExpandedFolders().clear();
            uiJCRExplorer.updateAjax(event);
        }
    }
}

