/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/action/UIAddFolder.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={OnChangeActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFolderForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TITLE_TEXT_BOX = "titleTextBox";
    public static final String FIELD_CUSTOM_TYPE_CHECK_BOX = "customTypeCheckBox";
    public static final String FIELD_CUSTOM_TYPE_SELECT_BOX = "customTypeSelectBox";
    private static final Log LOG = ExoLogger.getLogger((String)UIFolderForm.class.getName());
    private static final String DEFAULT_NAME = "untitled";
    private static final String MANAGED_SITES = "Managed Sites";
    private String selectedType;

    public UIFolderForm() throws Exception {
        UIFormStringInput titleTextBox = new UIFormStringInput(FIELD_TITLE_TEXT_BOX, FIELD_TITLE_TEXT_BOX, null);
        this.addUIFormInput((UIFormInput)titleTextBox);
        UICheckBoxInput customTypeCheckBox = new UICheckBoxInput(FIELD_CUSTOM_TYPE_CHECK_BOX, FIELD_CUSTOM_TYPE_CHECK_BOX, Boolean.valueOf(false));
        customTypeCheckBox.setRendered(false);
        customTypeCheckBox.setLabel("UIFolderForm".concat("label").concat(FIELD_CUSTOM_TYPE_CHECK_BOX));
        customTypeCheckBox.setOnChange("OnChange");
        this.addUIFormInput((UIFormInput)customTypeCheckBox);
        UIFormSelectBox customTypeSelectBox = new UIFormSelectBox(FIELD_CUSTOM_TYPE_SELECT_BOX, FIELD_CUSTOM_TYPE_SELECT_BOX, null);
        customTypeSelectBox.setRendered(false);
        this.addUIFormInput((UIFormInput)customTypeSelectBox);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() {
        block6: {
            try {
                UICheckBoxInput customTypeCheckBox = this.getUICheckBoxInput(FIELD_CUSTOM_TYPE_CHECK_BOX);
                UIFormSelectBox customTypeSelectBox = this.getUIFormSelectBox(FIELD_CUSTOM_TYPE_SELECT_BOX);
                UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
                List folderTypes = org.exoplatform.ecm.webui.utils.Utils.getAllowedFolderTypesInCurrentPath((Node)uiExplorer.getCurrentNode(), (DriveData)uiExplorer.getDriveData());
                if (folderTypes.size() > 1) {
                    customTypeCheckBox.setRendered(true);
                    if (MANAGED_SITES.equals(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getDriveData().getName())) {
                        customTypeCheckBox.setChecked(true);
                        customTypeSelectBox.setRendered(true);
                        this.fillCustomTypeSelectBox(folderTypes);
                    } else {
                        customTypeCheckBox.setChecked(false);
                        customTypeSelectBox.setRendered(false);
                    }
                } else {
                    customTypeCheckBox.setRendered(false);
                    customTypeSelectBox.setRendered(false);
                    this.setSelectedType((String)folderTypes.get(0));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block6;
                LOG.error("Unexpected error", new Object[]{e.getMessage()});
            }
        }
    }

    public void deActivate() {
    }

    private void fillCustomTypeSelectBox(List<String> folderTypes) throws Exception {
        UIFormSelectBox customTypeSelectBox = this.getUIFormSelectBox(FIELD_CUSTOM_TYPE_SELECT_BOX);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String folderType : folderTypes) {
            String label = this.getLabel(folderType.replace(":", "_"));
            options.add(new SelectItemOption(label, (Object)folderType));
        }
        Collections.sort(options, new ItemOptionNameComparator());
        customTypeSelectBox.setOptions(options);
    }

    public String getSelectedType() {
        return this.selectedType;
    }

    private void setSelectedType(String selectedType) {
        this.selectedType = selectedType;
    }

    public static class CancelActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIFolderForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIFolderForm uiFolderForm = (UIFolderForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiFolderForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiFolderForm.getAncestorOfType(UIApplication.class);
            List folderTypes = org.exoplatform.ecm.webui.utils.Utils.getAllowedFolderTypesInCurrentPath((Node)uiExplorer.getCurrentNode(), (DriveData)uiExplorer.getDriveData());
            UICheckBoxInput customTypeCheckBox = uiFolderForm.getUICheckBoxInput(UIFolderForm.FIELD_CUSTOM_TYPE_CHECK_BOX);
            UIFormSelectBox customTypeSelectBox = uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_CUSTOM_TYPE_SELECT_BOX);
            String title = (String)uiFolderForm.getUIStringInput(UIFolderForm.FIELD_TITLE_TEXT_BOX).getValue();
            Node currentNode = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFolderForm);
                return;
            }
            if (StringUtils.isBlank((String)title)) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.name-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFolderForm);
                return;
            }
            String name = Text.escapeIllegalJcrChars((String)Utils.cleanString((String)title));
            if (StringUtils.isEmpty((String)name)) {
                name = UIFolderForm.DEFAULT_NAME;
            }
            if (customTypeCheckBox.isRendered()) {
                if (customTypeCheckBox.isChecked()) {
                    String selectedValue = (String)customTypeSelectBox.getValue();
                    uiFolderForm.setSelectedType(selectedValue);
                } else if (folderTypes.contains("nt:folder")) {
                    uiFolderForm.setSelectedType("nt:folder");
                } else {
                    uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.ntFolder-not-avaiable", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFolderForm);
                    return;
                }
            }
            try {
                Node addedNode = currentNode.addNode(name, uiFolderForm.getSelectedType());
                if (!addedNode.hasProperty("exo:title")) {
                    addedNode.addMixin("exo:rss-enable");
                }
                addedNode.setProperty("exo:title", title);
                currentNode.save();
                uiExplorer.updateAjax(event);
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{uiFolderForm.getSelectedType()};
                throw new MessageException(new ApplicationMessage("UIFolderForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.repository-exception-permission", null, 1));
            }
            catch (ItemExistsException re) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.not-allow-sameNameSibling", null, 1));
            }
            catch (RepositoryException re) {
                String key = "UIFolderForm.msg.repository-exception";
                NodeDefinition[] definitions = currentNode.getPrimaryNodeType().getChildNodeDefinitions();
                boolean isSameNameSiblingsAllowed = false;
                for (NodeDefinition def : definitions) {
                    if (!def.allowsSameNameSiblings()) continue;
                    isSameNameSiblingsAllowed = true;
                    break;
                }
                if (currentNode.hasNode(name) && !isSameNameSiblingsAllowed) {
                    key = "UIFolderForm.msg.not-allow-sameNameSibling";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
            }
            catch (NumberFormatException nume) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.numberformat-exception", null, 1));
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
        }
    }

    public static class OnChangeActionListener
    extends EventListener<UIFolderForm> {
        public void execute(Event<UIFolderForm> event) throws Exception {
            UIFolderForm uiFolderForm = (UIFolderForm)((Object)event.getSource());
            UICheckBoxInput customTypeCheckBox = uiFolderForm.getUICheckBoxInput(UIFolderForm.FIELD_CUSTOM_TYPE_CHECK_BOX);
            UIFormSelectBox customTypeSelectBox = uiFolderForm.getUIFormSelectBox(UIFolderForm.FIELD_CUSTOM_TYPE_SELECT_BOX);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiFolderForm.getAncestorOfType(UIJCRExplorer.class);
            List folderTypes = org.exoplatform.ecm.webui.utils.Utils.getAllowedFolderTypesInCurrentPath((Node)uiExplorer.getCurrentNode(), (DriveData)uiExplorer.getDriveData());
            if (customTypeCheckBox.isChecked()) {
                uiFolderForm.fillCustomTypeSelectBox(folderTypes);
                customTypeSelectBox.setRendered(true);
            } else {
                customTypeSelectBox.setRendered(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFolderForm);
        }
    }
}

