/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.NodeFilter;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.http.ConnectionManager;
import org.htmlparser.http.ConnectionMonitor;
import org.htmlparser.http.HttpHeader;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.DefaultParserFeedback;
import org.htmlparser.util.IteratorImpl;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.ParserFeedback;
import org.htmlparser.visitors.NodeVisitor;

public class Parser
implements Serializable,
ConnectionMonitor {
    public static final double VERSION_NUMBER = 2.0;
    public static final String VERSION_TYPE = "Release Build";
    public static final String VERSION_DATE = "Sep 17, 2006";
    public static final String VERSION_STRING = "2.0 (Release Build Sep 17, 2006)";
    protected ParserFeedback mFeedback;
    protected Lexer mLexer;
    public static final ParserFeedback DEVNULL = new DefaultParserFeedback(0);
    public static final ParserFeedback STDOUT = new DefaultParserFeedback();

    public static String getVersion() {
        return VERSION_STRING;
    }

    public static double getVersionNumber() {
        return 2.0;
    }

    public static ConnectionManager getConnectionManager() {
        return Page.getConnectionManager();
    }

    public static void setConnectionManager(ConnectionManager manager) {
        Page.setConnectionManager(manager);
    }

    public static Parser createParser(String html, String charset) {
        if (null == html) {
            throw new IllegalArgumentException("html cannot be null");
        }
        Parser ret = new Parser(new Lexer(new Page(html, charset)));
        return ret;
    }

    public Parser() {
        this(new Lexer(new Page("")), DEVNULL);
    }

    public Parser(Lexer lexer, ParserFeedback fb) {
        this.setFeedback(fb);
        this.setLexer(lexer);
        this.setNodeFactory(new PrototypicalNodeFactory());
    }

    public Parser(URLConnection connection, ParserFeedback fb) throws ParserException {
        this(new Lexer(connection), fb);
    }

    public Parser(String resource, ParserFeedback feedback) throws ParserException {
        this.setFeedback(feedback);
        this.setResource(resource);
        this.setNodeFactory(new PrototypicalNodeFactory());
    }

    public Parser(String resource) throws ParserException {
        this(resource, STDOUT);
    }

    public Parser(Lexer lexer) {
        this(lexer, STDOUT);
    }

    public Parser(URLConnection connection) throws ParserException {
        this(connection, STDOUT);
    }

    public void setResource(String resource) throws ParserException {
        if (null == resource) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        int length = resource.length();
        boolean html = false;
        for (int i = 0; i < length; ++i) {
            char ch = resource.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if ('<' != ch) break;
            html = true;
            break;
        }
        if (html) {
            this.setLexer(new Lexer(new Page(resource)));
        } else {
            this.setLexer(new Lexer(Parser.getConnectionManager().openConnection(resource)));
        }
    }

    public void setConnection(URLConnection connection) throws ParserException {
        if (null == connection) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.setLexer(new Lexer(connection));
    }

    public URLConnection getConnection() {
        return this.getLexer().getPage().getConnection();
    }

    public void setURL(String url) throws ParserException {
        if (null != url && !"".equals(url)) {
            this.setConnection(Parser.getConnectionManager().openConnection(url));
        }
    }

    public String getURL() {
        return this.getLexer().getPage().getUrl();
    }

    public void setEncoding(String encoding) throws ParserException {
        this.getLexer().getPage().setEncoding(encoding);
    }

    public String getEncoding() {
        return this.getLexer().getPage().getEncoding();
    }

    public void setLexer(Lexer lexer) {
        if (null == lexer) {
            throw new IllegalArgumentException("lexer cannot be null");
        }
        NodeFactory factory = null;
        if (null != this.getLexer()) {
            factory = this.getLexer().getNodeFactory();
        }
        if (null != factory) {
            lexer.setNodeFactory(factory);
        }
        this.mLexer = lexer;
        String type = this.mLexer.getPage().getContentType();
        if (type != null && !type.startsWith("text")) {
            this.getFeedback().warning("URL " + this.mLexer.getPage().getUrl() + " does not contain text");
        }
    }

    public Lexer getLexer() {
        return this.mLexer;
    }

    public NodeFactory getNodeFactory() {
        return this.getLexer().getNodeFactory();
    }

    public void setNodeFactory(NodeFactory factory) {
        if (null == factory) {
            throw new IllegalArgumentException("node factory cannot be null");
        }
        this.getLexer().setNodeFactory(factory);
    }

    public void setFeedback(ParserFeedback fb) {
        this.mFeedback = null == fb ? DEVNULL : fb;
    }

    public ParserFeedback getFeedback() {
        return this.mFeedback;
    }

    public void reset() {
        this.getLexer().reset();
    }

    public NodeIterator elements() throws ParserException {
        return new IteratorImpl(this.getLexer(), this.getFeedback());
    }

    public NodeList parse(NodeFilter filter) throws ParserException {
        NodeList ret = new NodeList();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            if (null != filter) {
                node.collectInto(ret, filter);
                continue;
            }
            ret.add(node);
        }
        return ret;
    }

    public void visitAllNodesWith(NodeVisitor visitor) throws ParserException {
        visitor.beginParsing();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            Node node = e.nextNode();
            node.accept(visitor);
        }
        visitor.finishedParsing();
    }

    public void setInputHTML(String inputHTML) throws ParserException {
        if (null == inputHTML) {
            throw new IllegalArgumentException("html cannot be null");
        }
        if (!"".equals(inputHTML)) {
            this.setLexer(new Lexer(new Page(inputHTML)));
        }
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter) throws ParserException {
        NodeList ret = new NodeList();
        NodeIterator e = this.elements();
        while (e.hasMoreNodes()) {
            e.nextNode().collectInto(ret, filter);
        }
        return ret;
    }

    public void preConnect(HttpURLConnection connection) throws ParserException {
        this.getFeedback().info(HttpHeader.getRequestHeader(connection));
    }

    public void postConnect(HttpURLConnection connection) throws ParserException {
        this.getFeedback().info(HttpHeader.getResponseHeader(connection));
    }

    public static void main(String[] args) {
        if (args.length < 1 || args[0].equals("-help")) {
            System.out.println("HTML Parser v" + Parser.getVersion() + "\n");
            System.out.println();
            System.out.println("Syntax : java -jar htmlparser.jar <file/page> [type]");
            System.out.println("   <file/page> the URL or file to be parsed");
            System.out.println("   type the node type, for example:");
            System.out.println("     A - Show only the link tags");
            System.out.println("     IMG - Show only the image tags");
            System.out.println("     TITLE - Show only the title tag");
            System.out.println();
            System.out.println("Example : java -jar htmlparser.jar http://www.yahoo.com");
            System.out.println();
        } else {
            try {
                TagNameFilter filter;
                Parser parser = new Parser();
                if (1 < args.length) {
                    filter = new TagNameFilter(args[1]);
                } else {
                    filter = null;
                    parser.setFeedback(STDOUT);
                    Parser.getConnectionManager().setMonitor(parser);
                }
                Parser.getConnectionManager().setRedirectionProcessingEnabled(true);
                Parser.getConnectionManager().setCookieProcessingEnabled(true);
                parser.setResource(args[0]);
                System.out.println(parser.parse(filter));
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Parser.getConnectionManager();
        ConnectionManager.getDefaultRequestProperties().put("User-Agent", "HTMLParser/" + Parser.getVersionNumber());
    }
}

